/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreenFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenSchemeAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@WebSudoRequired
public class ViewFieldScreenSchemes
extends AbstractFieldScreenSchemeAction {
    private String confirm;
    private Map issueTypeScreenSchemeMap;
    private final FieldScreenFactory fieldScreenFactory;
    private final FieldScreenManager fieldScreenManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private Collection fieldScreens;
    private Long fieldScreenId;

    public ViewFieldScreenSchemes(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenFactory fieldScreenFactory, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldScreenManager fieldScreenManager) {
        super(fieldScreenSchemeManager);
        this.fieldScreenFactory = fieldScreenFactory;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldScreenManager = fieldScreenManager;
        this.issueTypeScreenSchemeMap = new HashMap();
    }

    protected String doExecute() throws Exception {
        return this.getResult();
    }

    public String doAddNewFieldScreenScheme() throws Exception {
        return "input";
    }

    @RequiresXsrfCheck
    public String doAddFieldScreenScheme() {
        this.validateName(false);
        if (!this.invalidInput()) {
            FieldScreenScheme fieldScreenScheme = this.fieldScreenFactory.createFieldScreenScheme();
            fieldScreenScheme.setName(this.getFieldScreenSchemeName());
            fieldScreenScheme.setDescription(this.getFieldScreenSchemeDescription());
            fieldScreenScheme.store();
            FieldScreenSchemeItem fieldScreenSchemeItem = this.fieldScreenFactory.createFieldScreenSchemeItem();
            fieldScreenSchemeItem.setIssueOperation(null);
            fieldScreenSchemeItem.setFieldScreen(this.fieldScreenManager.getFieldScreen(this.getFieldScreenId()));
            fieldScreenScheme.addFieldScreenSchemeItem(fieldScreenSchemeItem);
            return this.returnCompleteWithInlineRedirect("ConfigureFieldScreenScheme.jspa?id=" + fieldScreenScheme.getId());
        }
        return "error";
    }

    @RequiresXsrfCheck
    public String doDeleteFieldScreenScheme() {
        this.validateId();
        if (!this.invalidInput()) {
            FieldScreenScheme fieldScreenScheme = this.getFieldScreenScheme();
            fieldScreenScheme.remove();
            return this.redirectToView();
        }
        return this.getResult();
    }

    public String doViewDeleteFieldScreenScheme() {
        this.validateId();
        if (!this.invalidInput()) {
            return "confirm";
        }
        return this.getResult();
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public Collection getIssueTypeScreenSchemes(FieldScreenScheme fieldScreenScheme) {
        if (!this.issueTypeScreenSchemeMap.containsKey(fieldScreenScheme.getId())) {
            this.issueTypeScreenSchemeMap.put(fieldScreenScheme.getId(), this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes(fieldScreenScheme));
        }
        return (Collection)this.issueTypeScreenSchemeMap.get(fieldScreenScheme.getId());
    }

    public Collection getFieldScreens() {
        if (this.fieldScreens == null) {
            this.fieldScreens = this.fieldScreenManager.getFieldScreens();
        }
        return this.fieldScreens;
    }

    public Long getFieldScreenId() {
        return this.fieldScreenId;
    }

    public void setFieldScreenId(Long fieldScreenId) {
        this.fieldScreenId = fieldScreenId;
    }
}

