/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.scheme.AbstractEditScheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.JiraEntityUtils;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class EditScheme
extends AbstractEditScheme {
    private Long defaultLevel;

    @Override
    public SchemeManager getSchemeManager() {
        return (SchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class);
    }

    @Override
    public String getRedirectURL() {
        return "ViewIssueSecuritySchemes.jspa";
    }

    @Override
    public String doDefault() throws Exception {
        this.setDefaultLevel(this.getScheme().getLong("defaultlevel"));
        return super.doDefault();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        GenericValue updatedScheme = this.getScheme();
        updatedScheme.setString("name", this.getName());
        updatedScheme.setString("description", this.getDescription());
        updatedScheme.set("defaultlevel", (Object)this.getDefaultLevel());
        ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).updateScheme(updatedScheme);
        return this.getRedirect(this.getRedirectURL());
    }

    public Long getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(Long defaultLevel) {
        this.defaultLevel = defaultLevel == null || defaultLevel.equals(new Long(-1L)) ? null : defaultLevel;
    }

    public Map getSecurityLevels() {
        return JiraEntityUtils.createEntityMap(ComponentAccessor.getIssueSecurityLevelManager().getSchemeIssueSecurityLevels(this.getSchemeId()), "id", "name");
    }
}

