/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes.pro;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.cluster.lock.JiraClusterLockService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.IssueTypeSchemeService;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigPredicate;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.ProjectOption;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ExceptionUtil;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.issuetypes.pro.AssociateIssueTypeSchemes;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.ListOrderedMap;

@WebSudoRequired
public class SelectIssueTypeSchemeForProject
extends AssociateIssueTypeSchemes {
    private static final String CREATE_SCHEME = "createScheme";
    private static final String CHOOSE_SCHEME = "chooseScheme";
    private static final String CHOOSE_PROJECT = "chooseProject";
    private final JiraClusterLockService jiraClusterLockService;
    private Long projectId;
    private String createType;
    private Long sameAsProjectId;
    private String[] selectedOptions;
    private long subTaskCount = -1L;
    private long standardIssuesCount = -1L;
    private FeatureManager featureManager;
    private static final String PROPERTY_NON_CLUSTERSAFE_SCHEME_SELECTION = "com.atlassian.jira.web.action.admin.issuetypes.select.issue.type.scheme.nonclustersafe";

    public SelectIssueTypeSchemeForProject(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, ProjectManager projectManager, IssueManager issueManager, IssueTypeSchemeService issueTypeSchemeService, ClusterLockService clusterLockService, FeatureManager featureManager) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, projectManager, issueManager, issueTypeSchemeService);
        this.jiraClusterLockService = new JiraClusterLockService(clusterLockService);
        this.featureManager = featureManager;
    }

    @Override
    public String doDefault() throws Exception {
        FieldConfigScheme currentScheme = this.getCurrentIssueTypeScheme();
        if (currentScheme != null) {
            this.setSchemeId(currentScheme.getId());
        }
        this.setCreateType(CHOOSE_SCHEME);
        return "input";
    }

    protected void doValidation() {
        if (CREATE_SCHEME.equals(this.getCreateType())) {
            FieldConfigScheme existingAutoCreatedScheme = this.getExistingAutoCreatedScheme();
            if (existingAutoCreatedScheme != null) {
                this.addErrorMessage(this.getText("admin.errors.already.an.issue.type.scheme.with.that.name"));
            }
            if (this.getSelectedOptions() != null) {
                boolean hasNormalIssueType = false;
                boolean hasSubTaskIssueType = false;
                for (int i = 0; i < this.getSelectedOptions().length; ++i) {
                    String id = this.getSelectedOptions()[i];
                    IssueType issueType = ComponentAccessor.getConstantsManager().getIssueTypeObject(id);
                    if (!issueType.isSubTask()) {
                        hasNormalIssueType = true;
                        continue;
                    }
                    hasSubTaskIssueType = true;
                }
                if (!hasNormalIssueType) {
                    this.addError("selectedOptions", this.getText("admin.errors.must.select.at.least.one.standard.issue.type"));
                }
                try {
                    if (!hasSubTaskIssueType && this.getSubTaskIssuesCount() > 0L) {
                        this.addError("selectedOptions", this.getText("admin.errors.project.has.subtasks", "" + this.getSubTaskIssuesCount()));
                    }
                }
                catch (SearchException e) {
                    this.addErrorMessage(this.getText("admin.projects.issuetypescheme.error.sever", ExceptionUtil.getExceptionAsHtml(e)));
                }
            } else {
                this.addError("selectedOptions", this.getText("admin.errors.must.select.at.least.one.standard.issue.type"));
            }
        } else if (CHOOSE_PROJECT.equals(this.getCreateType()) && this.sameAsProjectId == null) {
            this.addError("sameAsProjectId", this.getText("admin.projects.issuetypescheme.error.must.select.project"));
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.setNewOrExistingConfigScheme();
        return this.setValueOfConfigScheme();
    }

    private String setValueOfConfigScheme() throws Exception {
        if (this.getCurrentIssueTypeScheme().equals(this.getConfigScheme())) {
            return this.getRedirectToIssueTypes();
        }
        return this.runClusterSafeIfEnabled(() -> {
            this.updateProjectList();
            return this.executeAndRedirect();
        });
    }

    private String runClusterSafeIfEnabled(Callable<String> f) throws Exception {
        if (this.featureManager.isEnabled(PROPERTY_NON_CLUSTERSAFE_SCHEME_SELECTION)) {
            return f.call();
        }
        return this.jiraClusterLockService.runInClusterLock(f, this.allSchemesLockName());
    }

    private String allSchemesLockName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private String getRedirectToIssueTypes() {
        return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getKey() + "/issuetypes");
    }

    private void updateProjectList() {
        if (this.getConfigScheme().isGlobal()) {
            this.setConfigScheme(this.getCurrentIssueTypeScheme());
            this.removeProjectFromList();
        } else {
            this.addProjectToList();
        }
    }

    private void addProjectToList() {
        FieldConfigScheme configScheme = this.getConfigScheme();
        ArrayList<Project> projectsList = new ArrayList<Project>(configScheme.getAssociatedProjectObjects());
        projectsList.add(this.getProject());
        this.setProjects(projectsList);
    }

    private void removeProjectFromList() {
        FieldConfigScheme configScheme = this.getConfigScheme();
        ArrayList projectsList = new ArrayList(configScheme.getAssociatedProjectObjects());
        projectsList.remove(this.getProject());
        this.setProjects(projectsList);
    }

    private void setNewOrExistingConfigScheme() {
        if (CREATE_SCHEME.equals(this.getCreateType())) {
            FieldConfigScheme createdScheme = this.issueTypeSchemeManager.create(this.getDefaultNameForNewScheme(), "", (List)Lists.newArrayList((Object[])this.getSelectedOptions()));
            this.setConfigScheme(createdScheme);
        } else if (CHOOSE_PROJECT.equals(this.getCreateType())) {
            FieldConfigScheme schemeOfSelectedProject = this.configSchemeManager.getFieldConfigScheme(this.sameAsProjectId);
            this.setConfigScheme(schemeOfSelectedProject);
        }
    }

    private String executeAndRedirect() throws Exception {
        String result = super.doExecute(false);
        ((Object)((Object)this)).getClass();
        if (result.equals("NO_REDIRECT")) {
            return this.getRedirectToIssueTypes();
        }
        return result;
    }

    public Project getProject() {
        return this.projectManager.getProjectObj(this.getProjectId());
    }

    public FieldConfigScheme getCurrentIssueTypeScheme() {
        return this.issueTypeSchemeManager.getConfigScheme(this.getProject());
    }

    public Collection getAllProjects() {
        return CollectionUtils.select(super.getAllProjects(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                ProjectOption projectOption = (ProjectOption)((Object)object);
                return !SelectIssueTypeSchemeForProject.this.getProjectId().toString().equals(projectOption.getId());
            }
        });
    }

    public List getAllSchemes() {
        return this.issueTypeSchemeManager.getAllSchemes();
    }

    public FieldConfigScheme getConfigSchemeForProject(String project) {
        return this.issueTypeSchemeManager.getConfigScheme(this.projectManager.getProjectObjByName(project));
    }

    public Map getTypeOptions() throws Exception {
        ListOrderedMap typeOptions = new ListOrderedMap();
        typeOptions.put((Object)CHOOSE_SCHEME, (Object)this.getText("admin.projects.issuetypescheme.radio1"));
        if (!this.getAllProjects().isEmpty()) {
            typeOptions.put((Object)CHOOSE_PROJECT, (Object)this.getText("admin.projects.issuetypescheme.radio2"));
        }
        typeOptions.put((Object)CREATE_SCHEME, (Object)this.getText("admin.projects.issuetypescheme.radio4"));
        return typeOptions;
    }

    public String getDefaultNameForNewScheme() {
        return this.getText("admin.projects.issuetypescheme.new.issue.type", this.getProject().getName());
    }

    public Collection<IssueConstantOption> getAllOptions() {
        String fieldId = this.getManageableOption().getFieldId();
        Collection constants = ComponentAccessor.getConstantsManager().getConstantObjects(fieldId);
        if (constants == null) {
            return new ArrayList<IssueConstantOption>();
        }
        return (Collection)constants.stream().map(IssueConstantOption::new).collect(CollectorsUtil.toNewArrayListWithSizeOf((Collection)constants));
    }

    public long getSubTaskIssuesCount() throws SearchException {
        if (this.subTaskCount == -1L) {
            this.subTaskCount = this.issueTypeSchemeService.getNumIssuesMatchingTypesInProjects(this.getLoggedInUser(), (Collection)EasyList.build((Object)this.getProjectId()), (Collection)EasyList.build((Object)"-3"));
        }
        return this.subTaskCount;
    }

    public long getStandardIssues() throws SearchException {
        if (this.standardIssuesCount == -1L) {
            this.standardIssuesCount = this.issueTypeSchemeService.getNumIssuesMatchingTypesInProjects(this.getLoggedInUser(), (Collection)EasyList.build((Object)this.getProjectId()), (Collection)EasyList.build((Object)"-2"));
        }
        return this.standardIssuesCount;
    }

    public FieldConfigScheme getExistingAutoCreatedScheme() {
        Collection c = CollectionUtils.select((Collection)this.issueTypeSchemeManager.getAllSchemes(), (Predicate)new FieldConfigPredicate(null, this.getDefaultNameForNewScheme()));
        if (c != null && !c.isEmpty()) {
            return (FieldConfigScheme)c.iterator().next();
        }
        return null;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getCreateType() {
        return this.createType;
    }

    public void setCreateType(String createType) {
        this.createType = createType;
    }

    public Long getSameAsProjectId() {
        return this.sameAsProjectId;
    }

    public void setSameAsProjectId(Long sameAsProjectId) {
        this.sameAsProjectId = sameAsProjectId;
    }

    public String[] getSelectedOptions() {
        return this.selectedOptions;
    }

    public void setSelectedOptions(String[] selectedOptions) {
        this.selectedOptions = selectedOptions;
    }
}

