/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.bc.user.GroupView;
import com.atlassian.jira.bc.user.UserApplicationHelper;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@WebSudoRequired
public class ViewUser
extends IssueActionSupport {
    protected String name;
    protected ApplicationUser user;
    private boolean showPasswordUpdateMsg;
    private Map<String, String> userProperties;
    protected final CrowdService crowdService;
    protected final CrowdDirectoryService crowdDirectoryService;
    protected final UserPropertyManager userPropertyManager;
    protected final UserManager userManager;
    protected final FeatureManager featureManager;
    private final UserApplicationHelper applicationHelper;

    public ViewUser(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, UserManager userManager, FeatureManager featureManager, UserApplicationHelper applicationHelper) {
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.userPropertyManager = userPropertyManager;
        this.userManager = userManager;
        this.featureManager = featureManager;
        this.applicationHelper = applicationHelper;
    }

    public ViewUser(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, UserManager userManager) {
        this(crowdService, crowdDirectoryService, userPropertyManager, userManager, (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class), (UserApplicationHelper)ComponentAccessor.getComponent(UserApplicationHelper.class));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationUser getUser() {
        return this.getApplicationUser();
    }

    public ApplicationUser getApplicationUser() {
        if (this.user == null) {
            this.user = this.userManager.getUserByName(this.getName());
        }
        return this.user;
    }

    public List<GroupView> getUserGroups() {
        return this.applicationHelper.getUserGroups(this.getApplicationUser());
    }

    public String getDirectoryName() {
        ApplicationUser user = this.getApplicationUser();
        if (this.userManager.isUserExisting(user)) {
            return this.crowdDirectoryService.findDirectoryById(user.getDirectoryId()).getName();
        }
        return "???";
    }

    protected String doExecute() throws Exception {
        this.retrieveUserMetaProperties();
        return super.doExecute();
    }

    protected void doValidation() {
        if (this.getUser() == null) {
            this.addErrorMessage(this.getText("admin.errors.users.user.does.not.exist"));
        }
    }

    protected void retrieveUserMetaProperties() {
        PropertySet userPropertySet;
        Collection keys;
        this.userProperties = new HashMap<String, String>();
        ApplicationUser user = this.getUser();
        if (user != null && (keys = (userPropertySet = this.userPropertyManager.getPropertySet(user)).getKeys(5)) != null) {
            for (String key : keys) {
                if (!key.startsWith("jira.meta.")) continue;
                this.userProperties.put(key.substring("jira.meta.".length()), userPropertySet.getString(key));
            }
        }
    }

    public boolean isShowPasswordUpdateMsg() {
        return this.showPasswordUpdateMsg;
    }

    public void setShowPasswordUpdateMsg(boolean showPasswordUpdateMsg) {
        this.showPasswordUpdateMsg = showPasswordUpdateMsg;
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public boolean isRemoteUserPermittedToEditSelectedUser() {
        return this.getUser() != null && (this.isSystemAdministrator() || !this.getGlobalPermissionManager().hasPermission(44, this.getApplicationUser()));
    }

    public boolean isSelectedUserEditable() {
        if (this.userManager.canUpdateUser(this.getApplicationUser())) {
            return this.isRemoteUserPermittedToEditSelectedUser();
        }
        return false;
    }

    public boolean isSelectedUsersGroupsEditable() {
        return this.userManager.canUpdateGroupMembershipForUser(this.getUser());
    }

    public boolean isSelectedUserApplicationAccessEditable() {
        return this.isSelectedUsersGroupsEditable();
    }

    public boolean canUpdateUserPassword() {
        return this.isSelectedUserEditable() && this.userManager.canUpdateUserPassword(this.getUser());
    }

    public boolean getShowNoAppsWarning() {
        return !this.applicationHelper.canUserLogin(this.getApplicationUser());
    }

    @Nonnull
    public Collection<UserApplicationHelper.ApplicationSelection> getSelectableApplications() {
        return this.applicationHelper.getApplicationsForUser(this.getApplicationUser());
    }
}

