/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowDraftResultAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.jira.workflow.names.WorkflowCopyNameFactory;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class PublishDraftWorkflow
extends AbstractWorkflowDraftResultAction {
    private final WorkflowService workflowService;
    private final WorkflowCopyNameFactory workflowCopyNameFactory;
    private boolean enableBackup = false;
    private boolean enableBackupSubmitted = false;
    private boolean madeDeliberateChoice = false;
    private String newWorkflowName;

    public PublishDraftWorkflow(WorkflowService workflowService, JiraWorkflow jiraWorkflow, WorkflowCopyNameFactory workflowCopyNameFactory, ProjectService projectService) {
        super(jiraWorkflow, projectService);
        this.workflowService = workflowService;
        this.workflowCopyNameFactory = workflowCopyNameFactory;
    }

    public String doDefault() throws Exception {
        this.generateWorkflowName();
        return "input";
    }

    private void generateWorkflowName() {
        this.newWorkflowName = this.workflowCopyNameFactory.createFrom(this.getWorkflow().getName(), this.getLocale());
    }

    protected void doValidation() {
        if (!this.enableBackupSubmitted) {
            this.addError("enableBackup", this.getText("admin.workflows.publish.error.save.backup"));
            if (StringUtils.isBlank((CharSequence)this.newWorkflowName)) {
                this.generateWorkflowName();
            }
        } else {
            this.setMadeDeliberateChoice(true);
        }
        if (this.enableBackup) {
            this.workflowService.validateCopyWorkflow(this.getJiraServiceContext(), StringUtils.trim((String)this.newWorkflowName));
        }
        this.workflowService.validateOverwriteWorkflow(this.getJiraServiceContext(), this.getWorkflow().getName());
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.enableBackup) {
            JiraWorkflow activeWorkflow = this.workflowService.getWorkflow(this.getJiraServiceContext(), this.getWorkflow().getName());
            this.workflowService.copyWorkflow(this.getJiraServiceContext(), StringUtils.trim((String)this.newWorkflowName), null, activeWorkflow);
        }
        this.workflowService.overwriteActiveWorkflow(this.getJiraServiceContext(), this.getWorkflow().getName());
        if (this.hasAnyErrors()) {
            return "error";
        }
        return this.finish("admin.workflows.draft.draftworkflow.now.active", this.getWorkflow().getName());
    }

    public boolean isEnableBackup() {
        return this.enableBackup;
    }

    public void setEnableBackup(boolean enableBackup) {
        this.enableBackupSubmitted = true;
        this.enableBackup = enableBackup;
    }

    public String getNewWorkflowName() {
        return this.newWorkflowName;
    }

    public void setNewWorkflowName(String newWorkflowName) {
        this.newWorkflowName = newWorkflowName;
    }

    public Collection getBooleanList() {
        return EasyList.build((Object)new TextOption("true", this.getText("common.words.yes")), (Object)new TextOption("false", this.getText("common.words.no")));
    }

    public String getWorkflowDisplayName() {
        return WorkflowUtil.getWorkflowDisplayName((JiraWorkflow)this.getWorkflow());
    }

    public boolean isMadeDeliberateChoice() {
        return this.madeDeliberateChoice;
    }

    public void setMadeDeliberateChoice(boolean madeDeliberateChoice) {
        this.madeDeliberateChoice = madeDeliberateChoice;
    }
}

