/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParametersImpl;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateResult;
import com.atlassian.jira.bc.issue.worklog.WorklogResult;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.mention.MentionService;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.issue.AbstractWorklogAction;
import com.atlassian.jira.web.action.issue.util.AttachmentHelper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class UpdateWorklog
extends AbstractWorklogAction {
    private Worklog worklog;
    private WorklogResult worklogResult;

    public UpdateWorklog(WorklogService worklogService, CommentService commentService, ProjectRoleManager projectRoleManager, JiraDurationUtils jiraDurationUtils, DateTimeFormatterFactory dateTimeFormatterFactory, FieldVisibilityManager fieldVisibilityManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, UserUtil userUtil, SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, AttachmentHelper attachmentHelper, MentionService mentionService) {
        super(worklogService, commentService, projectRoleManager, jiraDurationUtils, fieldVisibilityManager, fieldLayoutManager, rendererManager, userUtil, dateTimeFormatterFactory, subTaskManager, fieldScreenRendererFactory, fieldManager, attachmentHelper, mentionService);
    }

    @Override
    public String doDefault() throws Exception {
        if (this.getJiraServiceContext().getLoggedInApplicationUser() == null) {
            return "securitybreach";
        }
        this.worklog = this.worklogService.getById(this.getJiraServiceContext(), this.getWorklogId());
        if (this.worklog == null) {
            this.addErrorMessage(this.getText("logwork.error.update.invalid.id", this.getWorklogId() == null ? null : this.getWorklogId().toString()));
            return "error";
        }
        if (!this.worklogService.hasPermissionToUpdate(this.getJiraServiceContext(), this.worklog)) {
            return "securitybreach";
        }
        BigDecimal hoursPerDay = this.getHoursPerDay();
        BigDecimal daysPerWeek = this.getDaysPerWeek();
        BigDecimal secondsPerHour = BigDecimal.valueOf(DateUtils.Duration.HOUR.getSeconds());
        long secondsPerDay = hoursPerDay.multiply(secondsPerHour).longValueExact();
        long secondsPerWeek = daysPerWeek.multiply(hoursPerDay).multiply(secondsPerHour).longValueExact();
        this.setTimeLogged(DateUtils.getDurationStringSeconds((long)this.worklog.getTimeSpent(), (long)secondsPerDay, (long)secondsPerWeek));
        this.setStartDate(this.getFormattedStartDate(this.worklog.getStartDate()));
        this.setComment(this.worklog.getComment());
        this.setCommentLevel(CommentVisibility.getCommentLevelFromLevels(this.worklog.getGroupLevel(), this.worklog.getRoleLevelId()));
        return super.doDefault();
    }

    @Override
    public void doValidation() {
        this.populateAttachmentsFieldValuesHolderAndValidate();
        CommentVisibility commentVisibility = this.getCommentVisibility();
        Visibility visibility = Visibilities.fromGroupAndStrRoleId((String)commentVisibility.getGroupLevel(), (String)commentVisibility.getRoleLevel());
        WorklogInputParametersImpl.Builder builder = WorklogInputParametersImpl.timeSpent((String)this.getTimeLogged()).worklogId(this.getWorklogId()).startDate(this.getParsedStartDate()).comment(this.getComment()).visibility(visibility);
        if ("new".equalsIgnoreCase(this.adjustEstimate)) {
            WorklogNewEstimateInputParameters params = builder.newEstimate(this.getNewEstimate()).buildNewEstimate();
            this.worklogResult = this.worklogService.validateUpdateWithNewEstimate(this.getJiraServiceContext(), params);
        } else {
            WorklogInputParameters params = builder.build();
            this.worklogResult = this.worklogService.validateUpdate(this.getJiraServiceContext(), params);
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if ("auto".equalsIgnoreCase(this.adjustEstimate)) {
            this.worklogService.updateAndAutoAdjustRemainingEstimate(this.getJiraServiceContext(), this.worklogResult, true);
        } else if ("new".equalsIgnoreCase(this.adjustEstimate)) {
            this.worklogService.updateWithNewRemainingEstimate(this.getJiraServiceContext(), (WorklogNewEstimateResult)this.worklogResult, true);
        } else {
            this.worklogService.updateAndRetainRemainingEstimate(this.getJiraServiceContext(), this.worklogResult, true);
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        this.processAttachments();
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return this.getRedirect("/browse/" + this.getIssue().getString("key"));
    }

    public Worklog getWorklog() {
        if (this.worklog == null && this.worklogResult != null) {
            this.worklog = this.worklogResult.getWorklog();
        }
        return this.worklog;
    }

    public boolean isEditMode() {
        return true;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>();
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

