/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.comparator.PortalPageNameComparator;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.sharing.SharePermissionUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.UserSharingPreferencesUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.Longs;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.bean.ShareTypeRendererBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AddPortalPage
extends JiraWebActionSupport {
    private static final String SHARES_FIELD = "shares";
    private final PortalPageService portalPageService;
    private final ShareTypeFactory shareTypeFactory;
    private final JiraAuthenticationContext authCtx;
    private final PermissionManager permissionsManager;
    private final UserSharingPreferencesUtil userSharingPreferencesUtil;
    private final UserHistoryManager userHistoryManager;
    private String portalPageDescription = null;
    private String portalPageName = null;
    private String shareString = null;
    private SharedEntity.SharePermissions sharePermissions = SharedEntity.SharePermissions.PRIVATE;
    private List<ShareTypeRendererBean> types = null;
    private boolean favourite = true;
    private String clonePageId = null;
    private PortalPage clonePage = null;
    private Collection clonedTargetPages = null;
    private final FeatureManager featureManager;

    public AddPortalPage(PortalPageService portalPageService, ShareTypeFactory shareTypeFactory, UserSharingPreferencesUtil userSharingPreferencesUtil, JiraAuthenticationContext authCtx, PermissionManager permissionsManager, UserHistoryManager userHistoryManager, FeatureManager featureManager) {
        this.portalPageService = portalPageService;
        this.shareTypeFactory = shareTypeFactory;
        this.authCtx = authCtx;
        this.permissionsManager = permissionsManager;
        this.userSharingPreferencesUtil = userSharingPreferencesUtil;
        this.userHistoryManager = userHistoryManager;
        this.featureManager = featureManager;
    }

    public String doDefault() {
        this.setPermissions(SharedEntity.SharePermissions.PRIVATE);
        if (this.isEditEnabled()) {
            this.setPermissions(this.userSharingPreferencesUtil.getDefaultSharePermissions(this.getLoggedInUser()));
        }
        if (this.clonePageIdIsValid() && this.getClonePage() == null) {
            this.addErrorMessage(this.getText("addportalpage.clone.does.not.exist"));
            return "error";
        }
        return "input";
    }

    protected void doValidation() {
        this.setPermissions(SharedEntity.SharePermissions.PRIVATE);
        if (StringUtils.isNotBlank((CharSequence)this.shareString)) {
            try {
                SharedEntity.SharePermissions permissions = SharePermissionUtils.fromJsonArrayString((String)this.shareString);
                this.setPermissions(permissions);
            }
            catch (JSONException e) {
                this.log.error((Object)("Unable to parse the returned SharePermissions: " + e.getMessage()), (Throwable)e);
                this.addError(SHARES_FIELD, this.getText("common.sharing.parse.error"));
                return;
            }
        }
        JiraServiceContext serviceCtx = this.getJiraServiceContext();
        PortalPage newPortalPage = this.createNewPortalPage();
        if (this.clonePageIdGiven()) {
            if (this.clonePageIdIsValid()) {
                this.portalPageService.validateForCreatePortalPageByClone(serviceCtx, newPortalPage, this.getClonePageIdLongValue());
            } else {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.clone.does.not.exist"));
            }
        } else {
            this.portalPageService.validateForCreate(serviceCtx, newPortalPage);
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() {
        JiraServiceContext serviceCtx = this.getJiraServiceContext();
        PortalPage newPortalPage = this.clonePageIdIsValid() ? this.clonePortalPage(serviceCtx, this.getClonePageIdLongValue()) : this.createBlankPortalPage(serviceCtx);
        if (newPortalPage != null) {
            if (this.favourite) {
                this.userHistoryManager.addItemToHistory(UserHistoryItem.DASHBOARD, this.getLoggedInUser(), String.valueOf(newPortalPage.getId()));
                return this.getRedirect("ConfigurePortalPages.jspa?view=favourite");
            }
            return this.getRedirect("ConfigurePortalPages.jspa?view=my");
        }
        return "error";
    }

    public String getPortalPageDescription() {
        return this.portalPageDescription;
    }

    public void setPortalPageDescription(String portalPageDescription) {
        this.portalPageDescription = StringUtils.isNotBlank((CharSequence)portalPageDescription) ? portalPageDescription : null;
    }

    public Collection<PortalPage> getCloneTargetDashboardPages() {
        if (this.clonedTargetPages == null) {
            Object portalPage2;
            HashSet<Long> clonePageIds = new HashSet<Long>();
            PortalPage systemDefaultPortalPage = this.portalPageService.getSystemDefaultPortalPage();
            clonePageIds.add(systemDefaultPortalPage.getId());
            Collection favouritePortalPages = this.portalPageService.getFavouritePortalPages(this.getLoggedInUser());
            ArrayList<Object> clonePages = new ArrayList<Object>(favouritePortalPages.size() + 1);
            for (Object portalPage2 : favouritePortalPages) {
                if (!clonePageIds.add(portalPage2.getId())) continue;
                clonePages.add(portalPage2);
            }
            Collection myPages = this.portalPageService.getOwnedPortalPages(this.getLoggedInUser());
            portalPage2 = myPages.iterator();
            while (portalPage2.hasNext()) {
                PortalPage portalPage3 = (PortalPage)portalPage2.next();
                if (!clonePageIds.add(portalPage3.getId())) continue;
                clonePages.add(portalPage3);
            }
            if (this.clonePageIdIsValid() && !clonePageIds.contains(this.getClonePageIdLongValue()) && (portalPage2 = this.getClonePage()) != null) {
                clonePages.add(portalPage2);
            }
            Collections.sort(clonePages, new PortalPageNameComparator());
            clonePages.add(0, systemDefaultPortalPage);
            this.clonedTargetPages = Collections.unmodifiableCollection(clonePages);
        }
        return this.clonedTargetPages;
    }

    public String getPortalPageName() {
        return this.portalPageName;
    }

    public void setPortalPageName(String portalPageName) {
        this.portalPageName = portalPageName;
    }

    public void setShareValues(String values) {
        this.shareString = values;
    }

    private void setPermissions(SharedEntity.SharePermissions sharePermissions) {
        this.sharePermissions = sharePermissions;
    }

    private SharedEntity.SharePermissions getPermissions() {
        return this.sharePermissions;
    }

    public boolean isFavourite() {
        return this.favourite;
    }

    public void setFavourite(boolean favourite) {
        this.favourite = favourite;
    }

    public String getClonePageId() {
        return this.clonePageId;
    }

    public void setClonePageId(String clonePageId) {
        this.clonePageId = clonePageId;
    }

    public Collection getShareTypes() {
        if (this.types == null) {
            Collection sharesTypes = this.shareTypeFactory.getAllShareTypes();
            this.types = new ArrayList<ShareTypeRendererBean>(sharesTypes.size());
            for (ShareType shareType : sharesTypes) {
                this.types.add(new ShareTypeRendererBean(shareType, this.authCtx, ShareTypeRenderer.RenderMode.EDIT, PortalPage.ENTITY_TYPE));
            }
        }
        return this.types;
    }

    public Collection<ShareTypeRendererBean> getViewTypes() {
        return ShareTypeRendererBean.getShareTypeRendererBeans(this.authCtx, this.shareTypeFactory, ShareType.UsageContextType.VIEW, PortalPage.ENTITY_TYPE);
    }

    public Collection<ShareTypeRendererBean> getEditTypes() {
        return ShareTypeRendererBean.getShareTypeRendererBeans(this.authCtx, this.shareTypeFactory, ShareType.UsageContextType.VIEW_EDIT, PortalPage.ENTITY_TYPE);
    }

    public boolean showShares() {
        return this.isEditEnabled() || !this.getPermissions().isEmpty();
    }

    public boolean showEditors() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.SHARED_ENTITY_EDIT_RIGHTS);
    }

    public boolean isEditEnabled() {
        return this.permissionsManager.hasPermission(22, this.getLoggedInUser());
    }

    public String getJsonString() {
        ArrayList sortedShares = new ArrayList(this.getPermissions().getPermissionSet());
        Collections.sort(sortedShares, this.shareTypeFactory.getPermissionComparator());
        try {
            return SharePermissionUtils.toJsonArray(sortedShares).toString();
        }
        catch (JSONException e) {
            this.log.error((Object)("Unable to create JSON representation of shares: " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    private PortalPage getClonePage() {
        if (this.clonePageIdIsValid() && this.clonePage == null) {
            JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.getLoggedInUser(), (ErrorCollection)new SimpleErrorCollection());
            this.clonePage = this.portalPageService.getPortalPage((JiraServiceContext)ctx, this.getClonePageIdLongValue());
        }
        return this.clonePage;
    }

    private PortalPage createBlankPortalPage(JiraServiceContext serviceContext) {
        PortalPage newPortalPage = this.createNewPortalPage();
        if (this.portalPageService.validateForCreate(serviceContext, newPortalPage)) {
            return this.portalPageService.createPortalPage(serviceContext, newPortalPage, this.favourite);
        }
        return null;
    }

    private PortalPage clonePortalPage(JiraServiceContext serviceContext, Long clonePortalPageId) {
        PortalPage newPortalPage = this.createNewPortalPage();
        if (this.portalPageService.validateForCreatePortalPageByClone(serviceContext, newPortalPage, clonePortalPageId)) {
            return this.portalPageService.createPortalPageByClone(serviceContext, newPortalPage, clonePortalPageId, this.favourite);
        }
        return null;
    }

    private PortalPage createNewPortalPage() {
        ApplicationUser user = this.getLoggedInUser();
        return PortalPage.name((String)this.portalPageName).description(this.portalPageDescription).owner(user).permissions(this.getPermissions()).build();
    }

    private boolean clonePageIdGiven() {
        return this.clonePageId != null && !this.clonePageId.isEmpty();
    }

    private boolean clonePageIdIsValid() {
        return Longs.toLong((String)this.clonePageId).isPresent();
    }

    private Long getClonePageIdLongValue() {
        return (Long)Longs.toLong((String)this.clonePageId).get();
    }
}

