/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditDarkFeatures
extends JiraWebActionSupport {
    private static final Logger log = LoggerFactory.getLogger(EditDarkFeatures.class);
    private FeatureManager featureManager;
    private String featureKey;
    private String action;

    public EditDarkFeatures(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public String doDefault() throws Exception {
        return this.forceRedirect("ViewProfile.jspa?selectedTab=jira.user.profile.panels:up-darkfeatures-panel");
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        String feature;
        if (this.featureManager.isEnabled("jira.user.darkfeature.admin") && StringUtils.isNotEmpty((CharSequence)(feature = this.featureKey.trim()))) {
            ApplicationUser user = this.getLoggedInUser();
            try {
                if ("remove".equals(this.action)) {
                    this.featureManager.disableUserDarkFeature(user, feature);
                    log.debug("User '" + user.getName() + "' disabled Dark Feature '" + feature + "'");
                } else {
                    this.featureManager.enableUserDarkFeature(user, feature);
                    log.debug("User '" + user.getName() + "' enabled Dark Feature '" + feature + "'");
                }
            }
            catch (IllegalStateException e) {
                log.warn("User '" + user.getName() + "' attempted to change Core Feature '" + feature + "'. This feature may only be changed site-wide.");
            }
        }
        return this.forceRedirect("ViewProfile.jspa?selectedTab=jira.user.profile.panels:up-darkfeatures-panel");
    }

    public void setFeatureKey(String featureKey) {
        this.featureKey = featureKey;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

