/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.runtime.CommunicationException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.security.login.LoginResult;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.event.user.UserProfileUpdatedEvent;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import org.apache.commons.lang3.StringUtils;

public class EditProfile
extends JiraWebActionSupport {
    private static final int MAX_LENGTH = 255;
    private final CrowdService crowdService;
    private final UserManager userManager;
    private final EventPublisher eventPublisher;
    private final LoginService loginService;
    private String username;
    private String fullName;
    private String email;
    private String password;

    public EditProfile(CrowdService crowdService, UserManager userManager, EventPublisher eventPublisher, LoginService loginService) {
        this.crowdService = crowdService;
        this.userManager = userManager;
        this.eventPublisher = eventPublisher;
        this.loginService = loginService;
    }

    public String doDefault() throws Exception {
        ApplicationUser current = this.getLoggedInUser();
        if (current == null || !current.getName().equals(this.username)) {
            return "error";
        }
        if (!this.userManager.userCanUpdateOwnDetails(current)) {
            this.addErrorMessage(this.getText("editprofile.not.allowed"));
            return "error";
        }
        this.fullName = current.getDisplayName();
        this.email = current.getEmailAddress();
        return super.doDefault();
    }

    protected void doValidation() {
        ApplicationUser current = this.getLoggedInUser();
        if (current == null) {
            this.addErrorMessage("generic.notloggedin.title");
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.fullName)) {
            this.addError("fullName", this.getText("admin.errors.invalid.full.name.specified"));
        } else if (this.fullName.length() > 255) {
            this.addError("fullName", this.getText("signup.error.full.name.greater.than.max.chars"));
        }
        if (StringUtils.isBlank((CharSequence)this.email)) {
            this.addError("email", this.getText("admin.errors.invalid.email"));
        } else if (this.email.length() > 255) {
            this.addError("email", this.getText("signup.error.email.greater.than.max.chars"));
        }
        if (this.detailsHaveChanged(current)) {
            this.validatePassword(current);
        }
    }

    private void validatePassword(ApplicationUser current) {
        if (this.password == null) {
            this.addError("password", this.getText("user.profile.password.mismatch"));
        }
        try {
            LoginResult loginResult = this.loginService.authenticate(current, this.password);
            switch (loginResult.getReason()) {
                case OK: {
                    break;
                }
                case AUTHENTICATION_DENIED: {
                    this.addErrorMessage(this.getText("user.profile.elevated.authorisation.required"));
                    break;
                }
                case AUTHORISATION_FAILED: {
                    this.addErrorMessage(this.getText("user.profile.user.auth.failed"));
                    break;
                }
                case AUTHENTICATED_FAILED: {
                    this.addError("password", this.getText("user.profile.password.mismatch"));
                }
            }
        }
        catch (CommunicationException communicationException) {
            this.log.debug((Object)"Error communicating with remote user directory.", (Throwable)communicationException);
            this.addErrorMessage(this.getText("login.error.communication"));
        }
        catch (OperationFailedException operationFailedException) {
            this.log.debug((Object)("Error while trying to authenticate user '" + current.getName() + "'."), (Throwable)operationFailedException);
            this.addError("password", this.getText("login.error.misc"));
        }
        catch (Exception e) {
            this.log.debug((Object)"Exception occurred while trying to authorise current user.", (Throwable)e);
            this.addErrorMessage(this.getText("user.profile.user.auth.failed"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ApplicationUser current = this.getLoggedInUser();
        if (current == null || !current.getUsername().equals(this.username)) {
            return "error";
        }
        if (!this.userManager.userCanUpdateOwnDetails(current)) {
            this.addErrorMessage(this.getText("editprofile.not.allowed"));
            return "error";
        }
        if (this.detailsHaveChanged(current)) {
            UserTemplate user = new UserTemplate(current.getDirectoryUser());
            user.setDisplayName(this.fullName);
            user.setEmailAddress(this.email);
            try {
                this.crowdService.updateUser((User)user);
                this.eventPublisher.publish((Object)new UserProfileUpdatedEvent(current, this.getLoggedInUser()));
            }
            catch (OperationNotPermittedException e) {
                this.addErrorMessage(this.getText("admin.errors.cannot.edit.user.directory.read.only"));
            }
        }
        return this.returnComplete("ViewProfile.jspa");
    }

    private boolean detailsHaveChanged(ApplicationUser current) {
        return !this.eq(current.getDisplayName(), this.fullName) || !this.eq(current.getEmailAddress(), this.email);
    }

    private boolean eq(String s, String s1) {
        return StringUtils.defaultString((String)s).equals(StringUtils.defaultString((String)s1));
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean userCanUpdateOwnDetails() {
        return this.userManager.userCanUpdateOwnDetails(this.getLoggedInUser());
    }

    public boolean getElevatedSecurityCheckRequired() {
        return this.loginService.getLoginInfo(this.username).isElevatedSecurityCheckRequired();
    }
}

