/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.cron.generator;

import com.atlassian.jira.web.component.cron.CronEditorBean;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class CronIntervalGenerator {
    public long getDelayFromInput(CronEditorBean cronEditorBean) {
        long delay = TimeUnit.DAYS.toMillis(1L);
        if (cronEditorBean.isDailyMode()) {
            delay = this.generateDailyDelay(cronEditorBean);
        } else if (cronEditorBean.isDayPerWeekMode()) {
            delay = this.generateDaysOfWeekDelay();
        } else if (cronEditorBean.isDaysPerMonthMode()) {
            delay = this.generateDaysOfMonthOptDelay();
        } else if (cronEditorBean.isAdvancedMode()) {
            delay = TimeUnit.DAYS.toMillis(1L);
        }
        return delay;
    }

    long generateDaysOfMonthOptDelay() {
        return TimeUnit.DAYS.toMillis(31L);
    }

    long generateDaysOfWeekDelay() {
        return TimeUnit.DAYS.toMillis(7L);
    }

    long generateDailyDelay(CronEditorBean cronEditorBean) {
        int increment = this.getIntFromString(cronEditorBean.getIncrementInMinutes());
        if (increment == 0 || cronEditorBean.isDaysPerMonthMode()) {
            return TimeUnit.DAYS.toMillis(1L);
        }
        return TimeUnit.MINUTES.toMillis(increment);
    }

    int getIntFromString(String string) {
        if (string != null && !StringUtils.isEmpty((CharSequence)string)) {
            return Integer.parseInt(string);
        }
        return 0;
    }
}

