/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.security;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.web.filters.steps.security.PathExclusionModuleDescriptor;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ThreadSafe
public class HttpSecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(HttpSecurityConfig.class);
    private static final String DISABLE_CLICKJACKING_PROTECTION_PROPERTY = "com.atlassian.jira.clickjacking.protection.disabled";
    private static final String CLICKJACKING_PROTECTION_EXCLUDE_PROPERTY = "com.atlassian.jira.clickjacking.protection.exclude";
    private static final String SEPARATOR = ",";
    private static final List<String> DEFAULT_EXCLUDED_PATHS = ImmutableList.of((Object)"/rest/collectors/1.0/template/form/", (Object)"/rest/collectors/1.0/template/custom/", (Object)"/rest/collectors/1.0/template/feedback/", (Object)"/plugins/servlet/applinks/auth/conf/trusted/", (Object)"/plugins/servlet/applinks/auth/conf/basic/", (Object)"/plugins/servlet/applinks/auth/conf/oauth/");
    private final JiraProperties jiraProperties;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public HttpSecurityConfig(JiraProperties jiraProperties, PluginAccessor pluginAccessor) {
        this.jiraProperties = jiraProperties;
        this.pluginAccessor = pluginAccessor;
    }

    public boolean isClickjackingProtectionDisabled() {
        return this.jiraProperties.getBoolean(DISABLE_CLICKJACKING_PROTECTION_PROPERTY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExcluded(String path) {
        if (log.isDebugEnabled()) {
            log.debug("clickjacking.disabled={}; clickjacking excluded paths: {}", (Object)this.isClickjackingProtectionDisabled(), this.getExcludedPaths().collect(Collectors.toList()));
        }
        if (path == null) return false;
        if (!this.getExcludedPaths().anyMatch(path::startsWith)) return false;
        return true;
    }

    private String getClickjackingDefaultWhitelist() {
        return this.jiraProperties.getProperty(CLICKJACKING_PROTECTION_EXCLUDE_PROPERTY, "");
    }

    private Stream<String> getExcludedPaths() {
        return Stream.of(DEFAULT_EXCLUDED_PATHS.stream(), HttpSecurityConfig.obtainExcludedPathsFromProperty(this.getClickjackingDefaultWhitelist()), this.obtainExcludedPathsFromPlugins()).flatMap(x -> x);
    }

    private static Stream<String> obtainExcludedPathsFromProperty(String pathsParamValue) {
        return Arrays.stream(pathsParamValue.split(SEPARATOR)).map(String::trim).filter(StringUtils::isNotEmpty);
    }

    private Stream<String> obtainExcludedPathsFromPlugins() {
        List a = this.getSafeAccessViaPluginAccessor().forType(PathExclusionModuleDescriptor.class, (descriptor, pathExclusion) -> pathExclusion.getExcludedPaths().stream());
        return a.stream().flatMap(x -> x);
    }

    @VisibleForTesting
    SafeAccessViaPluginAccessor getSafeAccessViaPluginAccessor() {
        return SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
    }
}

