/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.security;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterStep;
import com.atlassian.jira.web.filters.steps.security.HttpSecurityConfig;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSecurityStep
implements FilterStep {
    private static final Logger log = LoggerFactory.getLogger(HttpSecurityStep.class);
    private static final String ASSETS_SERVLET_PATH = "/s";
    private static final String X_XSS_PROTECTION_VALUE = "1; mode=block";
    private static final String X_CONTENT_TYPE_OPTIONS_VALUE = "nosniff";
    private static final String X_FRAME_OPTIONS_VALUE = "SAMEORIGIN";
    private static final String CONTENT_SECURITY_POLICY_VALUE = "frame-ancestors 'self'";
    private HttpSecurityConfig httpSecurityConfig = this.getHttpSecurityConfig().orElse(null);

    public HttpSecurityStep() {
        if (this.httpSecurityConfig == null) {
            log.debug("All resources have clickjacking protection right now. That's OK for Jira in setup and start-up mode.");
        }
    }

    @Override
    public FilterCallContext beforeDoFilter(FilterCallContext context) {
        HttpServletRequest request = context.getHttpServletRequest();
        HttpServletResponse response = context.getHttpServletResponse();
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        log.debug("setting XSS and nosniff protection for servlet path [{}] for path [{}]", (Object)servletPath, (Object)pathInfo);
        response.setHeader("X-XSS-Protection", X_XSS_PROTECTION_VALUE);
        response.setHeader("X-Content-Type-Options", X_CONTENT_TYPE_OPTIONS_VALUE);
        boolean clickjackingProtection = true;
        if (!servletPath.equals(ASSETS_SERVLET_PATH) && this.httpSecurityConfig != null) {
            boolean bl = clickjackingProtection = !this.httpSecurityConfig.isClickjackingProtectionDisabled() && !this.httpSecurityConfig.isExcluded(HttpSecurityStep.combinePaths(servletPath, pathInfo));
        }
        if (clickjackingProtection) {
            log.debug("setting clickjacking protection for servlet path [{}] for path [{}]", (Object)servletPath, (Object)pathInfo);
            response.setHeader("X-Frame-Options", X_FRAME_OPTIONS_VALUE);
            response.setHeader("Content-Security-Policy", CONTENT_SECURITY_POLICY_VALUE);
        }
        return context;
    }

    @Override
    public FilterCallContext finallyAfterDoFilter(FilterCallContext context) {
        return context;
    }

    private Optional<HttpSecurityConfig> getHttpSecurityConfig() {
        return ComponentAccessor.getComponentSafely(HttpSecurityConfig.class);
    }

    private static String combinePaths(@NotNull String path, @Nullable String optionalPath) {
        StringBuilder sb = new StringBuilder(path);
        if (optionalPath != null) {
            sb.append(optionalPath);
        }
        return sb.toString();
    }
}

