/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.pagebuilder;

import com.atlassian.jira.web.pagebuilder.DecoratablePage;
import com.atlassian.jira.web.pagebuilder.Decorator;
import com.atlassian.jira.web.pagebuilder.JspDecorator;
import com.atlassian.jira.web.pagebuilder.JspDecoratorUtils;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractJspDecorator
implements Decorator,
JspDecorator {
    protected final WebResourceAssembler webResourceAssembler;
    protected final String headPrePath;
    protected final String headPostPath;
    protected final String bodyPrePath;
    protected final String bodyPostPath;
    private ServletContext servletContext;
    private HttpServletRequest request;
    private HttpServletResponse response;

    protected AbstractJspDecorator(WebResourceAssembler webResourceAssembler, String headPrePath, String headPostPath, String bodyPrePath, String bodyPostPath) {
        this.webResourceAssembler = webResourceAssembler;
        this.headPrePath = headPrePath;
        this.headPostPath = headPostPath;
        this.bodyPrePath = bodyPrePath;
        this.bodyPostPath = bodyPostPath;
    }

    @Override
    public void setContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.servletContext = servletContext;
        this.request = request;
        this.response = response;
    }

    @Override
    public void writePreHead(Writer writer) {
        this.writeTemplate(this.headPrePath);
    }

    @Override
    public void writeOnFlush(Writer writer) {
        this.webResourceAssembler.assembled().drainIncludedResources().writeHtmlTags(writer, UrlMode.RELATIVE);
    }

    @Override
    public void writePostHead(Writer writer, DecoratablePage.ParsedHead parsedHead) {
        try {
            JspDecoratorUtils.setParsedHead(parsedHead);
            this.writeTemplate(this.headPostPath);
        }
        finally {
            JspDecoratorUtils.clearParsedHead();
        }
    }

    @Override
    public void writePreBody(Writer writer, DecoratablePage.ParsedBody parsedBody) {
        try {
            JspDecoratorUtils.setParsedBody(parsedBody);
            this.writeTemplate(this.bodyPrePath);
        }
        finally {
            JspDecoratorUtils.clearParsedBody();
        }
    }

    @Override
    public void writePostBody(Writer writer, DecoratablePage.ParsedBody parsedBody) {
        try {
            JspDecoratorUtils.setParsedBody(parsedBody);
            this.writeTemplate(this.bodyPostPath);
        }
        finally {
            JspDecoratorUtils.clearParsedBody();
        }
    }

    private void writeTemplate(String path) {
        try {
            this.servletContext.getRequestDispatcher(path).include((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (ServletException ex) {
            throw new RuntimeException(ex);
        }
    }
}

