/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFormatPolicy;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.io.MediaConsumer;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class AvatarToStream {
    private final AvatarManager avatarManager;

    public AvatarToStream(AvatarManager avatarManager) {
        this.avatarManager = avatarManager;
    }

    public void sendAvatar(Avatar avatar, Avatar.Size size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        AvatarFormatPolicy avatarFormatPolicy = AvatarToStream.toAvatarRequestedFormat(Optional.ofNullable(request.getParameter("format")));
        HttpResponseHeaders.cachePrivatelyForAboutOneYear(response);
        this.avatarManager.readAvatarData(avatar, size, avatarFormatPolicy, new MediaConsumer(arg_0 -> ((HttpServletResponse)response).setContentType(arg_0), this.getDataConsumer(response)));
    }

    private Consumer<InputStream> getDataConsumer(HttpServletResponse response) {
        return stream -> {
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)stream);
                response.setContentLength(bytes.length);
                response.getOutputStream().write(bytes);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static AvatarFormatPolicy toAvatarRequestedFormat(Optional<String> imageFormat) {
        return imageFormat.filter(format -> !format.isEmpty()).map(String::toUpperCase).map(format -> {
            switch (format) {
                case "PNG": {
                    return AvatarFormatPolicy.createPngFormatPolicy().withFallingBackToOriginalDataStrategy();
                }
            }
            return AvatarFormatPolicy.createOriginalDataPolicy();
        }).orElse(AvatarFormatPolicy.createOriginalDataPolicy());
    }
}

