/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.session.currentusers;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.web.filters.accesslog.AtlassianSessionIdUtil;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionTracker;
import com.atlassian.sal.api.events.SessionDestroyedEvent;
import com.google.common.annotations.VisibleForTesting;
import java.security.Principal;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;

public class JiraUserSessionDestroyListener
implements HttpSessionListener {
    private static final Logger loggerSecurityEvents = LoginLoggers.LOGIN_SECURITY_EVENTS;

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession httpSession = event.getSession();
        if (httpSession != null && loggerSecurityEvents.isInfoEnabled()) {
            loggerSecurityEvents.info((Object)("HttpSession created [" + this.encodeSessionId(httpSession.getId()) + ']'));
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession httpSession;
        if (this.isPluginsUp() && (httpSession = event.getSession()) != null) {
            this.destroySession(httpSession);
        }
    }

    private void destroySession(HttpSession session) {
        this.getJiraSessionTracker().removeSession(session.getId());
        Principal principal = (Principal)session.getAttribute("seraph_defaultauthenticator_user");
        this.getEventPublisher().publish((Object)SessionDestroyedEvent.builder().sessionId(session.getId()).userName(principal == null ? null : principal.getName()).build());
        if (loggerSecurityEvents.isInfoEnabled()) {
            loggerSecurityEvents.info((Object)("HttpSession [" + this.encodeSessionId(session.getId()) + "] destroyed for '" + (principal == null ? "anonymous" : principal.getName()) + "'"));
        }
    }

    @VisibleForTesting
    JiraUserSessionTracker getJiraSessionTracker() {
        return JiraUserSessionTracker.getInstance();
    }

    @VisibleForTesting
    EventPublisher getEventPublisher() {
        return (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
    }

    @VisibleForTesting
    boolean isPluginsUp() {
        return ComponentManager.getInstance().getState().isPluginSystemStarted();
    }

    private String encodeSessionId(String id) {
        return AtlassianSessionIdUtil.generateASESSIONID(id);
    }
}

