/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.condition;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.util.GroupSelectorUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.condition.AbstractJiraCondition;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InGroupCFCondition
extends AbstractJiraCondition {
    private static final Logger log = LoggerFactory.getLogger(InGroupCFCondition.class);

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        CustomField field;
        CustomFieldManager fieldManager = ComponentAccessor.getCustomFieldManager();
        ApplicationUser caller = this.getCallerUser(transientVars, args);
        Issue issue = this.getIssue(transientVars);
        String cfKey = (String)args.get("groupcf");
        String cfName = (String)args.get("groupcfname");
        if (cfKey == null && cfName == null) {
            log.warn("Workflow condition " + ((Object)((Object)this)).getClass() + " is not configured with a custom field id ('groupcf') and name ('groupcfname')");
            return false;
        }
        if (cfKey != null) {
            field = fieldManager.getCustomFieldObject(cfKey);
            if (field == null) {
                log.error("No custom field with key '" + cfKey + '\'');
                return false;
            }
        } else {
            field = fieldManager.getCustomFieldObjectByName(cfName);
            if (field == null) {
                log.error("No custom field called '" + cfName + '\'');
                return false;
            }
        }
        GroupSelectorUtils groupSelectorUtils = (GroupSelectorUtils)ComponentAccessor.getComponent(GroupSelectorUtils.class);
        return groupSelectorUtils.isUserInCustomFieldGroup(issue, field, caller);
    }
}

