/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit.utilities;

import com.atlassian.jira.plugin.workflow.WorkflowFunctionModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.workflow.edit.utilities.FunctionDescriptorUtil;
import com.atlassian.jira.workflow.edit.utilities.WorkflowFunctionUtilities;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfTypePredicate;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import org.apache.log4j.Logger;

public class WorkflowFunctionUtilitiesImpl
implements WorkflowFunctionUtilities {
    private final DefaultPostFunctionPredicate defaultPostFunctionPredicate;
    private final FunctionDescriptorUtil functionDescriptorUtil;
    private final PluginAccessor pluginAccessor;

    public WorkflowFunctionUtilitiesImpl(FunctionDescriptorUtil functionDescriptorUtil, ModuleDescriptorFactory moduleDescriptorFactory, PluginAccessor pluginAccessor) {
        this.defaultPostFunctionPredicate = new DefaultPostFunctionPredicate(moduleDescriptorFactory);
        this.functionDescriptorUtil = functionDescriptorUtil;
        this.pluginAccessor = pluginAccessor;
    }

    private Collection<ModuleDescriptor<WorkflowPluginFunctionFactory>> getDefaultPostFunctionModuleDescriptors() {
        return this.pluginAccessor.getModuleDescriptors((Predicate)this.defaultPostFunctionPredicate);
    }

    @Override
    public Collection<FunctionDescriptor> getDefaultPostFunctions(@NotNull Supplier<Map<Integer, FunctionDescriptor>> additionalPostfunctionsSupplier) {
        TreeMap postFunctions = Maps.newTreeMap();
        for (ModuleDescriptor<WorkflowPluginFunctionFactory> descriptor : this.getDefaultPostFunctionModuleDescriptors()) {
            WorkflowFunctionModuleDescriptor postFunctionModule = (WorkflowFunctionModuleDescriptor)descriptor;
            FunctionDescriptor postFunction = this.functionDescriptorUtil.makeFunctionDescriptor(postFunctionModule);
            int weight = (Integer)MoreObjects.firstNonNull((Object)postFunctionModule.getWeight(), (Object)Integer.MAX_VALUE);
            postFunctions.put(weight, postFunction);
        }
        postFunctions.putAll(additionalPostfunctionsSupplier.get());
        return postFunctions.values();
    }

    static class DefaultPostFunctionPredicate
    implements Predicate<ModuleDescriptor<WorkflowPluginFunctionFactory>> {
        private final EnabledModulePredicate isEnabled = new EnabledModulePredicate();
        private final ModuleDescriptorOfTypePredicate<WorkflowPluginFunctionFactory> isPostFunction;
        private static final Logger LOG = Logger.getLogger(WorkflowFunctionUtilitiesImpl.class);

        public DefaultPostFunctionPredicate(ModuleDescriptorFactory moduleDescriptorFactory) {
            this.isPostFunction = new ModuleDescriptorOfTypePredicate(moduleDescriptorFactory, "workflow-function");
        }

        @Override
        public boolean test(ModuleDescriptor<WorkflowPluginFunctionFactory> moduleDescriptor) {
            try {
                boolean isEnabled = this.isEnabled.test(moduleDescriptor);
                boolean isPostFunction = this.isPostFunction.test(moduleDescriptor) && moduleDescriptor instanceof WorkflowFunctionModuleDescriptor;
                return isEnabled && isPostFunction && ((WorkflowFunctionModuleDescriptor)moduleDescriptor).isDefault();
            }
            catch (RuntimeException e) {
                LOG.warn((Object)"Could not perform a match against a module descriptor.", (Throwable)e);
                return false;
            }
        }
    }
}

