/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.IssueConstantImpl;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.model.querydsl.IssueTypeDTO;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.model.querydsl.QIssueType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import com.atlassian.jira.workflow.migration.WorkflowAsynchMigrator;
import com.atlassian.jira.workflow.migration.WorkflowMigrationMapping;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractWorkflowSchemeMigrationHelper<T extends WorkflowScheme>
implements WorkflowSchemeMigrationHelper<T> {
    private static final Logger log = Logger.getLogger(AbstractWorkflowSchemeMigrationHelper.class);
    final T targetScheme;
    final WorkflowManager workflowManager;
    protected final SchemeManager schemeManager;
    protected final List<IssueType> typesNeedingMigration;
    protected final Map<IssueType, Collection<Status>> statusesNeedingMigration;
    protected final WorkflowMigrationMapping workflowMigrationMapping;
    protected final OfBizDelegator delegator;
    protected final ApplicationUser user;
    protected final ConstantsManager constantsManager;
    protected final I18nHelper i18nHelper;
    final Long schemeId;
    protected final String schemeName;
    protected final TaskManager taskManager;
    protected final IssueIndexManager issueIndexManager;
    final WorkflowSchemeManager workflowSchemeManager;
    protected final EventPublisher eventPublisher;
    EnterpriseWorkflowTaskContext taskContext;
    private final IssueConstantFactory issueConstantFactory;
    private final QueryDslAccessor queryDslAccessor;

    AbstractWorkflowSchemeMigrationHelper(T targetScheme, WorkflowManager workflowManager, OfBizDelegator delegator, SchemeManager schemeManager, I18nHelper i18nHelper, ApplicationUser user, ConstantsManager constantsManager, TaskManager taskManager, IssueIndexManager issueIndexManager, WorkflowSchemeManager workflowSchemeManager, EventPublisher eventPublisher, IssueConstantFactory issueConstantFactory, QueryDslAccessor queryDslAccessor) {
        this.targetScheme = targetScheme;
        this.workflowManager = workflowManager;
        this.delegator = delegator;
        this.schemeManager = schemeManager;
        this.i18nHelper = i18nHelper;
        this.user = user;
        this.taskManager = taskManager;
        this.issueIndexManager = issueIndexManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.eventPublisher = eventPublisher;
        this.workflowMigrationMapping = new WorkflowMigrationMapping();
        this.constantsManager = constantsManager;
        this.typesNeedingMigration = new ArrayList<IssueType>();
        this.statusesNeedingMigration = Maps.newHashMap();
        this.issueConstantFactory = issueConstantFactory;
        this.queryDslAccessor = queryDslAccessor;
        if (targetScheme == null) {
            this.schemeId = null;
            this.schemeName = i18nHelper.getText("admin.common.words.default");
        } else {
            this.schemeId = targetScheme.getId();
            this.schemeName = targetScheme.getName();
        }
    }

    void calculateInputRequired() throws WorkflowException, GenericEntityException {
        Collection<IssueType> issueTypes = this.getRelatedIssueTypeIds();
        for (IssueType issueType : issueTypes) {
            String issueTypeId = issueType.getId();
            JiraWorkflow existingWorkflow = this.getExistingWorkflow(issueTypeId);
            JiraWorkflow targetWorkflow = this.getTargetWorkflow(issueTypeId);
            boolean needMigration = false;
            if (existingWorkflow.equals(targetWorkflow)) {
                Collection<Long> issueIdsOnWrongWorkflow = this.getIssueIdsOnWrongWorkflow(issueTypeId, existingWorkflow.getName());
                if (!issueIdsOnWrongWorkflow.isEmpty()) {
                    needMigration = true;
                    this.addIssueIdsOnWrongWorkflow(issueIdsOnWrongWorkflow);
                }
            } else {
                needMigration = true;
            }
            if (!needMigration) continue;
            HashSet<Status> existingStatuses = new HashSet<Status>(existingWorkflow.getLinkedStatusObjects());
            Collection<Status> actualExistingStatuses = this.getUniqueStatusesForIssueType(issueTypeId);
            existingStatuses.addAll(actualExistingStatuses);
            List targetStatuses = targetWorkflow.getLinkedStatusObjects();
            existingStatuses.removeAll(targetStatuses);
            if (!existingStatuses.isEmpty()) {
                this.typesNeedingMigration.add(issueType);
                this.statusesNeedingMigration.put(issueType, existingStatuses);
            }
            HashSet intersection = Sets.newHashSet((Iterable)existingWorkflow.getLinkedStatusObjects());
            intersection.addAll(actualExistingStatuses);
            intersection.retainAll(targetStatuses);
            for (Status status : intersection) {
                this.addMapping(issueType, status, status);
            }
        }
    }

    @Nonnull
    private Collection<IssueType> getRelatedIssueTypeIds() {
        QIssue issue = new QIssue("issue");
        QIssueType issueType = new QIssueType("issueType");
        List issueTypeDTOs = this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)Projections.constructor(IssueTypeDTO.class, (Expression[])new Expression[]{issueType.id, issueType.sequence, issueType.name, issueType.style, issueType.description, issueType.iconurl, issueType.avatar})).from((Expression)issueType)).where((Predicate)issueType.id.in((SubQueryExpression)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)issue.type).from((Expression)issue)).where((Predicate)this.isInCurrentProject(issue))).distinct()))).fetch());
        return issueTypeDTOs.stream().map(this.issueConstantFactory::createIssueType).collect(Collectors.toList());
    }

    abstract BooleanExpression isInCurrentProject(QIssue var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Long> getIssueIdsOnWrongWorkflow(String issueTypeId, String expectedWorkflowName) throws GenericEntityException {
        if (issueTypeId == null) {
            throw new IllegalArgumentException("Issue Type id should not be null.");
        }
        ArrayList<Long> issueIds = new ArrayList<Long>();
        try (OfBizListIterator listIterator = null;){
            EntityCondition projectIssueTypeClause = this.getProjectIssueTypeClause(issueTypeId, "issueType", "issueProject");
            EntityExpr workflowClause = new EntityExpr("workflowName", EntityOperator.NOT_EQUAL, (Object)expectedWorkflowName);
            EntityExpr condition = new EntityExpr(projectIssueTypeClause, EntityOperator.AND, (EntityCondition)workflowClause);
            listIterator = this.delegator.findListIteratorByCondition("IssueWorkflowEntryView", (EntityCondition)condition, null, Arrays.asList("issueId"), null, null);
            GenericValue issueIdGV = listIterator.next();
            while (issueIdGV != null) {
                issueIds.add(issueIdGV.getLong("issueId"));
                issueIdGV = listIterator.next();
            }
        }
        return Collections.unmodifiableList(issueIds);
    }

    private Collection<Status> getUniqueStatusesForIssueType(String issueTypeId) throws GenericEntityException {
        if (issueTypeId == null) {
            throw new NullPointerException("Issue Type should not be null.");
        }
        EntityCondition projectIssueTypeClause = this.getProjectIssueTypeClause(issueTypeId, "type", "project");
        return this.getUniqueStatuses(projectIssueTypeClause);
    }

    private EntityCondition getProjectIssueTypeClause(String issueTypeId, String issueTypeField, String projectField) {
        EntityFieldMap issueTypeClause = new EntityFieldMap((Map)ImmutableMap.of((Object)issueTypeField, (Object)issueTypeId), EntityOperator.AND);
        EntityCondition projectClause = this.getProjectClause(projectField);
        return new EntityExpr((EntityCondition)issueTypeClause, EntityOperator.AND, projectClause);
    }

    abstract EntityCondition getProjectClause(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Status> getUniqueStatuses(EntityCondition condition) throws GenericEntityException {
        ArrayList foundStatuses = Lists.newArrayList();
        try (OfBizListIterator listIterator = null;){
            EntityFindOptions findOptions = new EntityFindOptions();
            findOptions.setDistinct(true);
            listIterator = this.delegator.findListIteratorByCondition("Issue", condition, null, Arrays.asList("status"), null, findOptions);
            GenericValue statusIdGV = listIterator.next();
            while (statusIdGV != null) {
                Status statusGV = this.constantsManager.getStatusObject(statusIdGV.getString("status"));
                if (statusGV != null) {
                    foundStatuses.add(statusGV);
                } else {
                    this.getLogger().debug((Object)("Found issue with status id '" + statusIdGV.getString("status") + "'. The status for this id does not exist."));
                }
                statusIdGV = listIterator.next();
            }
        }
        return foundStatuses;
    }

    private void addIssueIdsOnWrongWorkflow(Collection<Long> issueIdsOnWrongWorkflow) {
        if (issueIdsOnWrongWorkflow != null) {
            this.workflowMigrationMapping.addIssueIdsOnWrongWorkflow(issueIdsOnWrongWorkflow);
        }
    }

    JiraWorkflow getExistingWorkflowByProjectId(String issueTypeId, long projectId) throws WorkflowException {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(Long.valueOf(projectId), issueTypeId);
        if (workflow == null) {
            throw new WorkflowException("Could not find workflow associated with project '" + projectId + "', issuetype " + issueTypeId);
        }
        return workflow;
    }

    abstract JiraWorkflow getExistingWorkflow(String var1) throws WorkflowException;

    JiraWorkflow getTargetWorkflow(String issueTypeId) throws WorkflowException {
        String workflowName = this.targetScheme.getActualWorkflow(issueTypeId);
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        if (workflow == null) {
            throw new WorkflowException("Could not find workflow associated with issuetype " + issueTypeId);
        }
        return workflow;
    }

    @Override
    public List<IssueType> getTypesNeedingMigration() {
        return this.typesNeedingMigration;
    }

    @Override
    public Collection<Status> getStatusesNeedingMigration(IssueType issueType) {
        return this.statusesNeedingMigration.get(issueType);
    }

    @Override
    public void addMapping(IssueType issueType, Status oldStatus, Status newStatus) {
        this.workflowMigrationMapping.addMapping(((IssueConstantImpl)issueType).getGenericValue(), ((IssueConstantImpl)oldStatus).getGenericValue(), ((IssueConstantImpl)newStatus).getGenericValue());
    }

    @Override
    public Logger getLogger() {
        return log;
    }

    @Override
    public boolean doQuickMigrate() throws GenericEntityException {
        if (this.isHaveIssuesToMigrate()) {
            return false;
        }
        this.quickMigrate();
        return true;
    }

    abstract void quickMigrate() throws GenericEntityException;

    @Override
    public boolean isHaveIssuesToMigrate() throws GenericEntityException {
        try (OfBizListIterator issueIterator = null;){
            issueIterator = this.delegator.findListIteratorByCondition("Issue", this.getProjectClause("project"));
            boolean bl = issueIterator.next() != null;
            return bl;
        }
    }

    @Override
    public TaskDescriptor<WorkflowMigrationResult> migrateAsync() throws RejectedExecutionException {
        String taskDesc = this.getMigrateAsyncTaskDesc();
        this.taskContext = this.createEnterpriseWorkflowTaskContext();
        return this.taskManager.submitTask(new WorkflowAsynchMigrator(this), taskDesc, this.taskContext);
    }

    abstract String getMigrateAsyncTaskDesc();

    abstract EnterpriseWorkflowTaskContext createEnterpriseWorkflowTaskContext();

    protected void copyAndDeleteDraftsForInactiveWorkflowsIn(WorkflowScheme workflowScheme) {
        Collection oldWorkflowNames = workflowScheme.getMappings().values();
        this.workflowManager.copyAndDeleteDraftsForInactiveWorkflowsIn(this.user, Iterables.transform(oldWorkflowNames, arg_0 -> ((WorkflowManager)this.workflowManager).getWorkflow(arg_0)));
    }
}

