/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstantImpl;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.task.StatefulTaskProgressSink;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationSuccess;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationTerminated;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.migration.WorkflowMigrationMapping;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProjectMigrator<T extends WorkflowScheme> {
    private static final Logger log = LoggerFactory.getLogger(ProjectMigrator.class);
    private final Project project;
    private final String projectName;
    private final Long projectId;
    private final T targetScheme;
    private final WorkflowManager workflowManager;
    private final SchemeManager schemeManager;
    private final OfBizDelegator delegator;
    private final ApplicationUser user;
    private final I18nHelper i18nHelper;
    private final IssueManager issueManager;
    private final IssueIndexManager issueIndexManager;
    private final OnCompleteCallback<T> onCompleteCallback;

    ProjectMigrator(Project project, T targetScheme, WorkflowManager workflowManager, SchemeManager schemeManager, OfBizDelegator delegator, ApplicationUser user, I18nHelper i18nHelper, IssueManager issueManager, IssueIndexManager issueIndexManager, OnCompleteCallback<T> onCompleteCallback) {
        this.project = project;
        this.targetScheme = targetScheme;
        this.workflowManager = workflowManager;
        this.schemeManager = schemeManager;
        this.delegator = delegator;
        this.user = user;
        this.i18nHelper = i18nHelper;
        this.issueManager = issueManager;
        this.issueIndexManager = issueIndexManager;
        this.onCompleteCallback = onCompleteCallback;
        this.projectName = project.getName();
        this.projectId = project.getId();
    }

    /*
     * Exception decompiling
     */
    public WorkflowMigrationResult migrate(TaskProgressSink sink, List<IssueType> typesNeedingMigration, WorkflowMigrationMapping workflowMigrationMapping) throws GenericEntityException, WorkflowException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private WorkflowMigrationResult migrateIssues(Collection issueIds, StatefulTaskProgressSink percentageSink, List<IssueType> typesNeedingMigration, WorkflowMigrationMapping workflowMigrationMapping) throws GenericEntityException {
        failedIssues = Maps.newHashMap();
        ProjectMigrator.log.info("Migrating issues in project '{}' to new workflow.", (Object)this.projectName);
        ignored = Timers.start((String)"Moving issues to new workflow");
        var7_7 = null;
        try {
            numberOfIssues = issueIds.size();
            issueCounter = 1L;
            issueSink = percentageSink.createStepSinkView(23L, 75L, numberOfIssues);
            currentSubTask = this.getI18nHelper().getText("admin.selectworkflowscheme.subtask.migration");
            iterator = issueIds.iterator();
            while (iterator.hasNext()) {
                block30: {
                    issueSink.makeProgress(issueCounter, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.migrate.issue", String.valueOf(issueCounter), String.valueOf(numberOfIssues), this.projectName));
                    issueId = (Long)iterator.next();
                    issue = this.retrieveIssue(issueId);
                    if (issue == null) break block30;
                    try {
                        originalWorkflow = this.workflowManager.getWorkflow(issue);
                        originalStatus = issue.getStatus();
                        originalWfIdString = Long.toString(issue.getWorkflowId());
                        targetStatus = originalStatus;
                        if (typesNeedingMigration.contains(issue.getIssueType())) {
                            targetStatus = workflowMigrationMapping.getTargetStatus(issue);
                        }
                        issueTypeId = issue.getIssueTypeId();
                        targetWorkflow = this.getTargetWorkflow(issueTypeId);
                        isIssueOnWrongWorkflow = workflowMigrationMapping.isIssueOnWrongWorkflow(issue.getId());
                        if (!isIssueOnWrongWorkflow && targetWorkflow.equals(this.getExistingWorkflow(issueTypeId))) ** GOTO lbl-1000
                        txn = Txn.begin();
                        try {
                            this.issueIndexManager.hold();
                            needsIndex = this.workflowManager.migrateIssueToWorkflowNoReindex(issue.getGenericValue(), targetWorkflow, ((IssueConstantImpl)targetStatus).getGenericValue());
                            this.createChangeLog(issue.getGenericValue(), originalWfIdString, originalStatus, originalWorkflow, targetWorkflow, targetStatus);
                            txn.commit();
                            if (needsIndex) {
                                this.reindexIssue(this.retrieveIssue(issueId));
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Exception e) {
                            txn.rollback();
                            throw e;
                        }
                        finally {
                            this.issueIndexManager.release();
                        }
                    }
                    catch (Exception e) {
                        ProjectMigrator.log.error("Error occurred while migrating issue to a new workflow for project '" + this.projectName + "'.", (Throwable)e);
                        failedIssues.put(issueId, issue.getKey());
                        if (failedIssues.size() >= 10) {
                            ProjectMigrator.log.info("Enterprise workflow migration cancelled due to number of errors during issues migration for project '" + this.projectName + "'.");
                            var17_19 = new WorkflowMigrationTerminated(failedIssues);
                            if (ignored != null) {
                                if (var7_7 != null) {
                                    try {
                                        ignored.close();
                                    }
                                    catch (Throwable var18_21) {
                                        var7_7.addSuppressed(var18_21);
                                    }
                                } else {
                                    ignored.close();
                                }
                            }
                            return var17_19;
                        }
                        ** break block31
                    }
                }
                ProjectMigrator.log.debug("Issue with id '" + issueId + "' not found.");
lbl-1000:
                // 4 sources

                {
                    ++issueCounter;
                }
            }
        }
        catch (Throwable var8_10) {
            var7_7 = var8_10;
            throw var8_10;
        }
        finally {
            if (ignored != null) {
                if (var7_7 != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable var8_9) {
                        var7_7.addSuppressed(var8_9);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        return new WorkflowMigrationSuccess(failedIssues);
    }

    private JiraWorkflow getExistingWorkflow(String issueTypeId) throws WorkflowException {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(this.projectId, issueTypeId);
        if (workflow == null) {
            throw new WorkflowException("Could not find workflow associated with project '" + this.projectId + "', issuetype " + issueTypeId);
        }
        return workflow;
    }

    private JiraWorkflow getTargetWorkflow(String issueTypeId) throws WorkflowException {
        String workflowName = this.targetScheme.getActualWorkflow(issueTypeId);
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        if (workflow == null) {
            throw new WorkflowException("Could not find workflow associated with issuetype " + issueTypeId);
        }
        return workflow;
    }

    private void reindexIssue(Issue issue) {
        String issueKey = issue.getString("key");
        try (Ticker ignored = Timers.start((String)("Reindexing issue: " + issueKey));){
            ((IssueIndexManager)ComponentAccessor.getComponent(IssueIndexManager.class)).reIndex(issue);
        }
        catch (IndexException e) {
            log.error("Error occurred while reindexing issue: " + issueKey, (Throwable)e);
        }
    }

    private void createChangeLog(GenericValue issue, String originalWfIdString, Status originalStatus, JiraWorkflow originalWorkflow, JiraWorkflow targetWorkflow, Status targetStatus) {
        String newwfIdString = issue.getLong("workflowId").toString();
        ArrayList changeItems = Lists.newArrayList();
        boolean createChangeLog = false;
        if (!originalWfIdString.equals(newwfIdString)) {
            changeItems.add(new ChangeItemBean("jira", "Workflow", originalWfIdString, originalWorkflow.getName(), newwfIdString, targetWorkflow.getName()));
            createChangeLog = true;
        }
        if (!originalStatus.getId().equals(targetStatus.getId())) {
            changeItems.add(new ChangeItemBean("jira", "status", originalStatus.getId(), originalStatus.getName(), targetStatus.getId(), targetStatus.getName()));
            createChangeLog = true;
        }
        try {
            if (createChangeLog) {
                ChangeLogUtils.createChangeGroup(this.getUser(), issue, issue, (Collection<ChangeItemBean>)changeItems, true);
            }
        }
        catch (Exception e) {
            log.error("Error occurred creating change log: " + e, (Throwable)e);
        }
    }

    void complete(SchemeManager schemeManager, Project project, T workflowScheme, StatefulTaskProgressSink migrationSink) throws GenericEntityException {
        this.onCompleteCallback.onComplete(schemeManager, project, workflowScheme, migrationSink);
    }

    private String getTargetSchemeName() {
        if (this.targetScheme == null) {
            return this.getI18nHelper().getText("admin.common.words.default");
        }
        return this.targetScheme.getName();
    }

    ApplicationUser getUser() {
        return this.user;
    }

    I18nHelper getI18nHelper() {
        return this.i18nHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Long> getIssueIds(Long projectId) throws GenericEntityException {
        log.debug("Returning all issues associated with project.");
        ArrayList issueIds = Lists.newArrayList();
        try (OfBizListIterator issueIterator = null;){
            EntityFieldMap cond = new EntityFieldMap((Map)ImmutableMap.of((Object)"project", (Object)projectId), EntityOperator.AND);
            issueIterator = this.delegator.findListIteratorByCondition("Issue", (EntityCondition)cond, null, Arrays.asList("id"), null, null);
            GenericValue issueIdGV = issueIterator.next();
            while (issueIdGV != null) {
                issueIds.add(issueIdGV.getLong("id"));
                issueIdGV = issueIterator.next();
            }
        }
        return issueIds;
    }

    private Issue retrieveIssue(Long issueId) throws GenericEntityException {
        return this.issueManager.getIssueObject(issueId);
    }

    public static interface OnCompleteCallback<T extends WorkflowScheme> {
        public void onComplete(SchemeManager var1, Project var2, T var3, StatefulTaskProgressSink var4) throws GenericEntityException;
    }
}

