/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.configurable;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.configurable.ObjectConfigurationFactory;
import com.atlassian.configurable.ObjectConfigurationImpl;
import com.atlassian.configurable.ObjectConfigurationProperty;
import com.atlassian.configurable.ObjectConfigurationPropertyImpl;
import com.atlassian.configurable.ObjectConfigurationTypes;
import com.atlassian.configurable.ObjectDescriptor;
import com.atlassian.configurable.StringObjectDescription;
import com.atlassian.configurable.ValuesGeneratorObjectConfigurationProperty;
import com.atlassian.configurable.XMLValuesObjectConfigurationProperty;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XMLObjectConfigurationFactory
implements ObjectConfigurationFactory {
    private final Map<String, ObjectConfigurationHolder> configs = new HashMap<String, ObjectConfigurationHolder>();

    public boolean hasObjectConfiguration(String id) {
        return this.configs.containsKey(id);
    }

    public ObjectConfiguration getObjectConfiguration(String id, Map params) throws ObjectConfigurationException {
        if (this.configs.containsKey(id)) {
            return this.configs.get(id).getObjectConfiguration(params);
        }
        throw new ObjectConfigurationException("Could not find Object Configuration with id: " + id);
    }

    public void loadObjectConfiguration(String xmlFile, String id) throws ObjectConfigurationException {
        this.loadObjectConfiguration(xmlFile, id, this.getClass().getClassLoader());
    }

    public void loadObjectConfiguration(String xmlFile, String id, ClassLoader classLoader) throws ObjectConfigurationException {
        if (xmlFile != null) {
            InputStream is = classLoader.getResourceAsStream(xmlFile);
            if (is == null) {
                throw new ObjectConfigurationException("Unable to load the configuration file '" + xmlFile + "' please ensure the file exists.");
            }
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read(is);
                Element root = doc.getRootElement();
                Element objectDescriptor = root.element("description");
                StringObjectDescription od = objectDescriptor.attribute("class") != null ? (ObjectDescriptor)classLoader.loadClass(objectDescriptor.attributeValue("class")).newInstance() : new StringObjectDescription(objectDescriptor.getTextTrim());
                this.loadObjectConfigurationFromElement(root, od, id);
            }
            catch (DocumentException e) {
                throw new ObjectConfigurationException("An Error occurred trying to parse the configuration file '" + xmlFile + "' please ensure the file exists.", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new ObjectConfigurationException("An Error occurred loading class:", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ObjectConfigurationException("An Error occurred loading class:", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ObjectConfigurationException("An Error occurred loading class:", (Throwable)e);
            }
        }
    }

    public void loadObjectConfigurationFromElement(Element element, ObjectDescriptor od, String id) {
        this.loadObjectConfigurationFromElement(element, od, id, this.getClass().getClassLoader());
    }

    public void loadObjectConfigurationFromElement(Element element, ObjectDescriptor od, String id, ClassLoader classLoader) {
        ObjectConfigurationHolder conf;
        Element propss = element.element("properties");
        ListOrderedMap values = new ListOrderedMap();
        if (propss != null) {
            List props = propss.elements("property");
            for (Object prop1 : props) {
                Element enabledConditionElement;
                Element defaultValueElement;
                Element prop = (Element)prop1;
                String defaultValue = "";
                String description = "";
                Element descriptionElement = prop.element("description");
                if (descriptionElement != null) {
                    description = descriptionElement.getTextTrim();
                }
                if ((defaultValueElement = prop.element("default")) != null) {
                    defaultValue = defaultValueElement.getTextTrim();
                }
                String enabledConditionClassName = (enabledConditionElement = prop.element("enabled-condition")) != null ? enabledConditionElement.attributeValue("class") : null;
                Element valuesElement = prop.element("values");
                String propertyName = prop.element("name").getTextTrim();
                String propertyTypeName = prop.element("type").getTextTrim();
                int propertyType = this.getTypeInt(propertyTypeName);
                if (valuesElement != null) {
                    Attribute valueGeneratorClassAttribute = valuesElement.attribute("class");
                    if (valueGeneratorClassAttribute != null) {
                        String generatorClass = valuesElement.attributeValue("class");
                        ValuesGeneratorObjectConfigurationProperty ocp = new ValuesGeneratorObjectConfigurationProperty(propertyName, description, defaultValue, propertyType, propertyTypeName, generatorClass, enabledConditionClassName, classLoader);
                        if (prop.element("i18n") != null) {
                            ocp.setI18nValues(!"false".equals(prop.element("i18n").getTextTrim()));
                        }
                        if (prop.element("cascade-from") != null) {
                            ocp.setCascadeFrom(prop.element("cascade-from").getTextTrim());
                        }
                        values.put(prop.element("key").getTextTrim(), ocp);
                        continue;
                    }
                    XMLValuesObjectConfigurationProperty ocp = new XMLValuesObjectConfigurationProperty(propertyName, description, defaultValue, propertyType, propertyTypeName, valuesElement, enabledConditionClassName, classLoader);
                    if (prop.element("i18n") != null) {
                        ocp.setI18nValues(!"false".equals(prop.element("i18n").getTextTrim()));
                    }
                    if (prop.element("cascade-from") != null) {
                        ocp.setCascadeFrom(prop.element("cascade-from").getTextTrim());
                    }
                    values.put(prop.element("key").getTextTrim(), ocp);
                    continue;
                }
                values.put(prop.element("key").getTextTrim(), new ObjectConfigurationPropertyImpl(propertyName, description, defaultValue, propertyType, propertyTypeName, enabledConditionClassName, classLoader));
            }
        }
        if (od != null) {
            Map validatedValues = od.validateProperties((Map)values);
            conf = new ObjectConfigurationHolder(id, validatedValues, od);
        } else {
            conf = new ObjectConfigurationHolder(id, (Map<String, ObjectConfigurationProperty>)values, od);
        }
        this.configs.put(id, conf);
    }

    private int getTypeInt(String typeName) {
        try {
            return Integer.parseInt(typeName);
        }
        catch (NumberFormatException e) {
            return ObjectConfigurationTypes.getType((String)typeName);
        }
    }

    private class ObjectConfigurationHolder {
        String id;
        Map<String, ObjectConfigurationProperty> configProperties;
        ObjectDescriptor od;

        ObjectConfigurationHolder(String id, Map<String, ObjectConfigurationProperty> configProperties, ObjectDescriptor od) {
            this.id = id;
            this.configProperties = configProperties;
            this.od = od;
        }

        ObjectConfiguration getObjectConfiguration(Map userParams) {
            ObjectConfigurationImpl oc = new ObjectConfigurationImpl(this.configProperties, this.od);
            oc.init(userParams);
            return oc;
        }
    }
}

