/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.check.CheckAmendment;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class SearchRequestRelationCheck
extends CheckImpl {
    public SearchRequestRelationCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.search.request.relation.check.desc");
    }

    @Override
    public List preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List correct() throws IntegrityException {
        return this.doCheck(true);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }

    private List doCheck(boolean correct) throws IntegrityException {
        ArrayList<CheckAmendment> results = new ArrayList<CheckAmendment>();
        ArrayList<GenericValue> filtersToRemove = new ArrayList<GenericValue>();
        try (OfBizListIterator listIterator = this.ofBizDelegator.findListIteratorByCondition("SearchRequest", null);){
            GenericValue filter = listIterator.next();
            while (filter != null) {
                if (TextUtils.stringSet((String)filter.getString("project")) && this.ofBizDelegator.findById("Project", filter.getLong("project")) == null) {
                    String message;
                    if (correct) {
                        message = this.getI18NBean().getText("admin.integrity.check.search.request.relation.check.message", filter.getString("name"));
                        results.add(new CheckAmendment(2, message, "JRA-2279"));
                        filtersToRemove.add(filter);
                    } else {
                        message = this.getI18NBean().getText("admin.integrity.check.search.request.relation.check.preview", filter.getString("name"));
                        results.add(new CheckAmendment(2, message, "JRA-2279"));
                    }
                }
                filter = listIterator.next();
            }
        }
        if (correct && !filtersToRemove.isEmpty()) {
            try {
                this.ofBizDelegator.removeAll(filtersToRemove);
            }
            catch (DataAccessException e) {
                throw new IntegrityException(e);
            }
        }
        return results;
    }
}

