/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditingCategory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditEntitiesUtils {
    private AuditEntitiesUtils() {
    }

    public static AuditType newAuditTypeWithTranslations(@Nonnull CoverageArea area, @Nonnull String categoryI18nKey, @Nonnull String actionI18nKey, @Nonnull CoverageLevel level, @Nullable String categoryTranslation, @Nullable String actionTranslation) {
        return AuditType.fromI18nKeys((CoverageArea)area, (CoverageLevel)level, (String)categoryI18nKey, (String)actionI18nKey).withCategoryTranslation(categoryTranslation).withActionTranslation(actionTranslation).build();
    }

    @Deprecated
    public static AuditType newAuditType(@Nonnull CoverageArea area, @Nonnull AuditingCategory category, @Nonnull String actionI18nKey, @Nonnull CoverageLevel level) {
        return AuditEntitiesUtils.newAuditType(area, category.getNameI18nKey(), actionI18nKey, level);
    }

    public static AuditType newAuditType(@Nonnull CoverageArea area, @Nonnull String categoryI18nKey, @Nonnull String actionI18nKey, @Nonnull CoverageLevel level) {
        return AuditType.fromI18nKeys((CoverageArea)area, (CoverageLevel)level, (String)categoryI18nKey, (String)actionI18nKey).build();
    }

    public static AuditAttribute newAuditAttribute(@Nonnull String nameI18nKey, @Nullable String value) {
        return AuditAttribute.fromI18nKeys((String)nameI18nKey, (String)value).build();
    }

    public static List<AuditAttribute> newAuditAttributes(@Nonnull Map<String, String> attributes) {
        return attributes.entrySet().stream().map(attr -> AuditEntitiesUtils.newAuditAttribute((String)attr.getKey(), (String)attr.getValue())).collect(Collectors.toList());
    }

    public static ChangedValue newChangedValue(@Nonnull String i18nKey, @Nullable String to) {
        return ChangedValue.fromI18nKeys((String)i18nKey).to(to).build();
    }

    public static ChangedValue newChangedValue(@Nonnull String i18nKey, @Nullable String from, @Nullable String to) {
        return ChangedValue.fromI18nKeys((String)i18nKey).from(from).to(to).build();
    }

    public static ChangedValue newChangedValueWithTranslation(@Nonnull String i18nKey, @Nullable String from, @Nullable String to, @Nullable String keyTranslation) {
        return ChangedValue.fromI18nKeys((String)i18nKey).withKeyTranslation(keyTranslation).from(from).to(to).build();
    }

    public static AuditResource newAuditResource(@Nonnull String name, @Nonnull String type, @Nonnull String id) {
        return AuditResource.builder((String)name, (String)type).id(id).build();
    }

    public static Optional<String> getExtraAttributeByI18nKeyOrName(@Nonnull AuditEntity auditEntity, @Nonnull String i18nKey, @Nonnull String name) {
        Optional attribute = auditEntity.getExtraAttributeByI18nKey(i18nKey);
        if (!attribute.isPresent()) {
            attribute = auditEntity.getExtraAttribute(name);
        }
        return attribute;
    }
}

