/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.converters;

import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.AuditingEntry;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.ChangedValueImpl;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class AuditingEntries {
    public static final String LEGACY_DESCRIPTION = "description";
    private final UserManager userManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    public AuditingEntries(UserManager userManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager) {
        this.userManager = userManager;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    public AuditingEntry from(RecordRequest record) {
        ApplicationUser author = record.getAuthor() != null ? record.getAuthor() : this.getLoggedInUser();
        AuditingEntry.Builder entry = AuditingEntry.builder(record.getCategory(), record.getSummary(), record.getEventSource()).categoryName(record.getCategoryName()).remoteAddress(StringUtils.defaultString((String)record.getRemoteAddress(), (String)this.getRemoteAddress())).author(author).actionI18nKey(record.getActionI18nKey()).objectItem(record.getObjectItem()).changedValues((Iterable<ChangedValue>)record.getChangedValues()).associatedItems((Iterable<AssociatedItem>)record.getAssociatedItems()).isAuthorSysAdmin(this.permissionManager.hasPermission(44, author)).description(record.getDescription());
        return entry.build();
    }

    public AuditingEntry from(AuditEntity entity) {
        AuditingCategory category = Objects.requireNonNull(AuditingCategory.getCategoryById((String)entity.getAuditType().getCategory()));
        AuditingEntry.Builder auditingEntryBuilder = AuditingEntry.builder(category, entity.getAuditType().getAction(), entity.getSource() != null ? entity.getSource() : "").author(this.getAuthor(entity.getAuthor()));
        List associatedItems = StreamSupport.stream(entity.getAffectedObjects().spliterator(), false).map(this::toAssociatedItem).collect(Collectors.toList());
        if (!associatedItems.isEmpty()) {
            auditingEntryBuilder.objectItem((AssociatedItem)associatedItems.get(0));
            List<AssociatedItem> extraItems = associatedItems.subList(1, associatedItems.size());
            if (!extraItems.isEmpty()) {
                auditingEntryBuilder.associatedItems(extraItems);
            }
        }
        this.addRemoteAddress(auditingEntryBuilder);
        auditingEntryBuilder.categoryName(category.getNameI18nKey());
        AuditEntitiesUtils.getExtraAttributeByI18nKeyOrName(entity, "jira.auditing.extra.parameters.event.description", LEGACY_DESCRIPTION).ifPresent(auditingEntryBuilder::description);
        this.addChangedValues(auditingEntryBuilder, entity.getChangedValues());
        return auditingEntryBuilder.build();
    }

    @Nullable
    protected String getRemoteAddress() {
        return ExecutingHttpRequest.get() != null ? ExecutingHttpRequest.get().getRemoteAddr() : null;
    }

    protected ApplicationUser getLoggedInUser() {
        return this.authenticationContext.getLoggedInUser();
    }

    private void addChangedValues(AuditingEntry.Builder auditingEntryBuilder, Iterable<com.atlassian.audit.entity.ChangedValue> changedValues) {
        if (changedValues.iterator().hasNext()) {
            auditingEntryBuilder.changedValues(StreamSupport.stream(changedValues.spliterator(), false).map(changedValue -> new ChangedValueImpl(changedValue.getKey(), changedValue.getFrom(), changedValue.getTo())).collect(Collectors.toList()));
        }
    }

    private void addRemoteAddress(AuditingEntry.Builder auditingEntryBuilder) {
        HttpServletRequest httpServletRequest = ExecutingHttpRequest.get();
        auditingEntryBuilder.remoteAddress(httpServletRequest != null ? httpServletRequest.getRemoteAddr() : null);
    }

    private ApplicationUser getAuthor(AuditAuthor author) {
        if (author.getType().equals(AuditAuthor.SYSTEM_AUTHOR.getType())) {
            return null;
        }
        return this.userManager.getUserByKey(author.getId());
    }

    private AssociatedItem toAssociatedItem(AuditResource resource) {
        return new RecordRequest.AssociatedItemImpl(resource.getName(), resource.getId(), AssociatedItem.Type.valueOf((String)resource.getType()));
    }
}

