/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDetailsChangedEvent;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.ApplicationLinksEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;

@AuditExceptionSafe
public class ApplicationLinksEventHandlerImpl
implements ApplicationLinksEventHandler {
    @VisibleForTesting
    static final AuditType APPLICATION_LINK_ADDED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.GENERAL_CONFIGURATION, "jira.auditing.application.link.added", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType APPLICATION_LINK_CHANGED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.GENERAL_CONFIGURATION, "jira.auditing.application.link.changed", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType APPLICATION_LINK_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.GENERAL_CONFIGURATION, "jira.auditing.application.link.deleted", CoverageLevel.ADVANCED);
    private static final String I18N_APPLICATION_LINK_ID = "jira.auditing.application.link.id";
    private static final String I18N_APPLICATION_LINK_TYPE = "jira.auditing.application.link.type";
    private static final String I18N_APPLICATION_LINK_DISPLAY_URL = "jira.auditing.application.link.display.url";
    private static final String I18N_APPLICATION_LINK_URL = "jira.auditing.application.link.application.url";
    private static final String I18N_APPLICATION_LINK_NAME = "jira.auditing.application.link.application.name";
    private final AuditService auditService;

    public ApplicationLinksEventHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleApplicationLinkAddedEvent(ApplicationLinkAddedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)APPLICATION_LINK_ADDED).affectedObject(AuditResource.builder((String)event.getApplicationLink().getName(), (String)AssociatedItem.Type.APPLICATION_LINK.name()).id(event.getApplicationLink().getId().toString()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_APPLICATION_LINK_NAME, event.getApplicationLink().getName())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_APPLICATION_LINK_URL, event.getApplicationLink().getRpcUrl().toString())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_APPLICATION_LINK_DISPLAY_URL, event.getApplicationLink().getDisplayUrl().toString())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_APPLICATION_LINK_TYPE, event.getApplicationLink().getType().toString())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_APPLICATION_LINK_ID, event.getApplicationLink().getId().toString())).build());
    }

    @Override
    @ThrowSafe
    public void handleApplicationLinkChangedEvent(ApplicationLinkDetailsChangedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)APPLICATION_LINK_CHANGED).affectedObject(AuditResource.builder((String)event.getApplicationLink().getName(), (String)AssociatedItem.Type.APPLICATION_LINK.name()).id(event.getApplicationLink().getId().toString()).build()).changedValues(new ChangedValuesBuilder().add(I18N_APPLICATION_LINK_NAME, null, event.getApplicationLink().getName()).add(I18N_APPLICATION_LINK_URL, null, event.getApplicationLink().getRpcUrl().toString()).add(I18N_APPLICATION_LINK_DISPLAY_URL, null, event.getApplicationLink().getDisplayUrl().toString()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_APPLICATION_LINK_TYPE, event.getApplicationLink().getType().toString())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_APPLICATION_LINK_ID, event.getApplicationLink().getId().toString())).build());
    }

    @Override
    @ThrowSafe
    public void handleApplicationLinkDeletedEvent(ApplicationLinkDeletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)APPLICATION_LINK_DELETED).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_APPLICATION_LINK_ID, event.getApplicationLink().getId().toString())).build());
    }
}

