/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.ChangedValueImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class ChangedValuesBuilder {
    final List<ChangedValue> changedValues = Lists.newArrayListWithCapacity((int)4);

    public ChangedValuesBuilder addIfDifferent(String name, String from, String to) {
        if (from == null && to != null || from != null && !from.equals(to)) {
            this.changedValues.add(ChangedValuesBuilder.createI18nChangeValue(name, from, to));
        }
        return this;
    }

    public ImmutableList<ChangedValue> build() {
        return ImmutableList.copyOf(this.changedValues);
    }

    private static ChangedValueImpl createI18nChangeValue(String name, String from, String to) {
        return new ChangedValueImpl(name, from, to);
    }

    public ChangedValuesBuilder add(String name, String from, String to) {
        this.changedValues.add(ChangedValuesBuilder.createI18nChangeValue(name, from, to));
        return this;
    }
}

