/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.BufferingAuditService;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.converters.AuditResources;
import com.atlassian.jira.auditing.handlers.ClusterNodeAuditHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

@ParametersAreNonnullByDefault
@AuditExceptionSafe
public class ClusterNodeAuditHandlerImpl
implements ClusterNodeAuditHandler {
    private static final AuditType NODE_ADDED = ClusterNodeAuditHandlerImpl.auditTypeForAction("jira.auditing.cluster.node.added");
    private static final AuditType NODE_REACTIVATED = ClusterNodeAuditHandlerImpl.auditTypeForAction("jira.auditing.cluster.node.reactivated");
    private static final AuditType NODE_DEACTIVATED = ClusterNodeAuditHandlerImpl.auditTypeForAction("jira.auditing.cluster.node.deactivated");
    private static final AuditType NODE_UPDATED = ClusterNodeAuditHandlerImpl.auditTypeForAction("jira.auditing.cluster.node.updated");
    private static final AuditType NODE_REMOVED = ClusterNodeAuditHandlerImpl.auditTypeForAction("jira.auditing.cluster.node.removed");
    private final BufferingAuditService bufferingAuditService;
    private final ComponentReference<I18nHelper.BeanFactory> i18nBeanFactoryRef = ComponentAccessor.getComponentReference(I18nHelper.BeanFactory.class);

    private static AuditType auditTypeForAction(String actionKey) {
        return AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.CLUSTERING, actionKey, CoverageLevel.ADVANCED);
    }

    public ClusterNodeAuditHandlerImpl(BufferingAuditService bufferingAuditService) {
        this.bufferingAuditService = bufferingAuditService;
    }

    @Override
    @ThrowSafe
    public void handleNodeAdded(Node added, Collection<Node> allNodes) {
        this.handleEvent(NODE_ADDED, added, null, added, allNodes);
    }

    @Override
    @ThrowSafe
    public void handleNodeReactivated(Node reactivated, Node oldNode, Collection<Node> allNodes) {
        this.handleEvent(NODE_REACTIVATED, reactivated, oldNode, reactivated, allNodes);
    }

    @Override
    @ThrowSafe
    public void handleNodeDeactivated(Node deactivated, Node oldNode, Collection<Node> allNodes) {
        this.handleEvent(NODE_DEACTIVATED, deactivated, oldNode, deactivated, allNodes);
    }

    @Override
    @ThrowSafe
    public void handleNodeUpdated(Node updated, Node oldNode, Collection<Node> allNodes) {
        this.handleEvent(NODE_UPDATED, updated, oldNode, updated, allNodes);
    }

    @Override
    @ThrowSafe
    public void handleNodeRemoved(Node removed, Collection<Node> allNodes) {
        this.handleEvent(NODE_REMOVED, removed, removed, null, allNodes);
    }

    private void handleEvent(AuditType type, Node affectedNode, @Nullable Node from, @Nullable Node to, Collection<Node> allNodes) {
        this.bufferingAuditService.auditOrPutToQueue(() -> AuditEvent.builder((AuditType)type).affectedObject(AuditResources.from(affectedNode)).changedValues(this.getChangedValues(from, to)).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.cluster.node.affected.id", affectedNode.getNodeId())).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.cluster.status", this.toAttributeString(allNodes))).build());
    }

    private ImmutableList<ChangedValue> getChangedValues(@Nullable Node from, @Nullable Node to) {
        return new ChangedValuesBuilder().addIfDifferent("admin.systeminfo.cluster.node.state", Optional.ofNullable(from).map(node -> this.getI18nHelper().getText(node.getState().getI18nKey())).orElse(null), Optional.ofNullable(to).map(node -> this.getI18nHelper().getText(node.getState().getI18nKey())).orElse(null)).addIfDifferent("admin.systeminfo.cluster.node.state.ip", Optional.ofNullable(from).map(Node::getIp).orElse(null), Optional.ofNullable(to).map(Node::getIp).orElse(null)).addIfDifferent("admin.systeminfo.cluster.node.cache.listener.port", Optional.ofNullable(from).map(node -> String.valueOf(node.getCacheListenerPort())).orElse(null), Optional.ofNullable(to).map(node -> String.valueOf(node.getCacheListenerPort())).orElse(null)).addIfDifferent("admin.systeminfo.cluster.node.build.number", Optional.ofNullable(from).map(node -> String.valueOf(node.getNodeBuildNumber())).orElse(null), Optional.ofNullable(to).map(node -> String.valueOf(node.getNodeBuildNumber())).orElse(null)).addIfDifferent("admin.systeminfo.cluster.node.version", Optional.ofNullable(from).map(Node::getNodeVersion).orElse(null), Optional.ofNullable(to).map(Node::getNodeVersion).orElse(null)).build();
    }

    private I18nHelper getI18nHelper() {
        return ((I18nHelper.BeanFactory)this.i18nBeanFactoryRef.get()).getInstance(Locale.ENGLISH);
    }

    private String toAttributeString(Collection<Node> allNodes) {
        ArrayList<String> attrList = new ArrayList<String>();
        this.addToAttrList(attrList, Node.NodeState.ACTIVE, allNodes);
        this.addToAttrList(attrList, Node.NodeState.OFFLINE, allNodes);
        return StringUtils.join(attrList, (String)"; ");
    }

    private void addToAttrList(List<String> attrList, Node.NodeState state, Collection<Node> nodes) {
        List ids = nodes.stream().filter(Objects::nonNull).filter(node -> node.getState() == state).map(node -> StringUtils.defaultString((String)node.getNodeId(), (String)"")).sorted().map(StringEscapeUtils::escapeHtml4).collect(Collectors.toList());
        if (ids.size() > 0) {
            String key = this.getI18nHelper().getText(state.getI18nKey());
            String value = StringUtils.join(ids, (String)", ");
            attrList.add(StringUtils.joinWith((String)": ", (Object[])new Object[]{key, value}));
        }
    }
}

