/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.handlers.CommentReactionsHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.reactions.analytics.CommentReactionsDisabledEvent;
import com.atlassian.jira.reactions.analytics.CommentReactionsEnabledEvent;
import com.google.common.annotations.VisibleForTesting;

@AuditExceptionSafe
public class CommentReactionsHandlerImpl
implements CommentReactionsHandler {
    @VisibleForTesting
    static final AuditType COMMENT_REACTIONS_ENABLED = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"jira.auditing.category.comment.reactions", (String)"jira.auditing.comment.reactions.enabled").build();
    @VisibleForTesting
    static final AuditType COMMENT_REACTIONS_DISABLED = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"jira.auditing.category.comment.reactions", (String)"jira.auditing.comment.reactions.disabled").build();
    private final AuditService auditService;

    public CommentReactionsHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleCommentReactionEnabled(CommentReactionsEnabledEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)COMMENT_REACTIONS_ENABLED).build());
    }

    @Override
    @ThrowSafe
    public void handleCommentReactionDisabled(CommentReactionsDisabledEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)COMMENT_REACTIONS_DISABLED).build());
    }
}

