/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.handlers.EmailEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.mail.EmailQueueFlushedEvent;
import com.atlassian.jira.event.mail.OutgoingEmailConfigurationChangedEvent;
import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;

@AuditExceptionSafe
public class EmailEventHandlerImpl
implements EmailEventHandler {
    @VisibleForTesting
    static final AuditType MAIL_QUEUE_FLUSHED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.MAIL_SETTINGS, "jira.auditing.mail.queue.flushed", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType MAILSERVERS_OUTGOING_TOGGLE_DISABLE = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.MAIL_SETTINGS, "admin.mailservers.outgoing.toggle.disable", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType MAILSERVERS_OUTGOING_TOGGLE_ENABLE = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.MAIL_SETTINGS, "admin.mailservers.outgoing.toggle.enable", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    @Inject
    public EmailEventHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleEmailConfigurationChanged(OutgoingEmailConfigurationChangedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)(event.isDisabled() ? MAILSERVERS_OUTGOING_TOGGLE_DISABLE : MAILSERVERS_OUTGOING_TOGGLE_ENABLE)).build());
    }

    @Override
    @ThrowSafe
    public void handleEmailQueueFlushed(EmailQueueFlushedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)MAIL_QUEUE_FLUSHED).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.mail.queue.number.of.messages", String.valueOf(event.getMailQueue().size()))).build());
    }
}

