/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.handlers.EmailTemplatesEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.mail.template.EmailTemplatesAppliedEvent;
import com.atlassian.jira.event.mail.template.EmailTemplatesDownloadedEvent;
import com.atlassian.jira.event.mail.template.EmailTemplatesRevertedEvent;
import com.atlassian.jira.event.mail.template.EmailTemplatesUploadedEvent;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;

@AuditExceptionSafe
public class EmailTemplatesEventHandlerImpl
implements EmailTemplatesEventHandler {
    private static final String ACTION_I18N_KEY_PREFIX = "jira.auditing.mail.templates.";
    @VisibleForTesting
    static final String ACTION_I18N_KEY_DOWNLOADED = "jira.auditing.mail.templates.downloaded";
    @VisibleForTesting
    static final String ACTION_I18N_KEY_UPLOADED = "jira.auditing.mail.templates.uploaded";
    @VisibleForTesting
    static final String ACTION_I18N_KEY_APPLIED = "jira.auditing.mail.templates.applied";
    @VisibleForTesting
    static final String ACTION_I18N_KEY_REVERTED = "jira.auditing.mail.templates.reverted";
    static final AuditType EMAIL_TEMPLATES_DOWNLOADED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.mailsettings", "jira.auditing.mail.templates.downloaded", CoverageLevel.ADVANCED);
    static final AuditType EMAIL_TEMPLATES_UPLOADED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.mailsettings", "jira.auditing.mail.templates.uploaded", CoverageLevel.ADVANCED);
    static final AuditType EMAIL_TEMPLATES_APPLIED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.mailsettings", "jira.auditing.mail.templates.applied", CoverageLevel.ADVANCED);
    static final AuditType EMAIL_TEMPLATES_REVERTED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.mailsettings", "jira.auditing.mail.templates.reverted", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    @Inject
    public EmailTemplatesEventHandlerImpl(@NotNull AuditService auditService) {
        this.auditService = (AuditService)Assertions.notNull((Object)auditService);
    }

    @Override
    @ThrowSafe
    public void handleEmailTemplatesDownloadedEvent(EmailTemplatesDownloadedEvent event) {
        if (event.isOperationSuccessful()) {
            this.auditService.audit(AuditEvent.builder((AuditType)EMAIL_TEMPLATES_DOWNLOADED).build());
        }
    }

    @Override
    @ThrowSafe
    public void handleEmailTemplatesUploadedEvent(EmailTemplatesUploadedEvent event) {
        if (event.isOperationSuccessful()) {
            this.auditService.audit(AuditEvent.builder((AuditType)EMAIL_TEMPLATES_UPLOADED).build());
        }
    }

    @Override
    @ThrowSafe
    public void handleEmailTemplatesAppliedEvent(EmailTemplatesAppliedEvent event) {
        if (event.isOperationSuccessful()) {
            this.auditService.audit(AuditEvent.builder((AuditType)EMAIL_TEMPLATES_APPLIED).build());
        }
    }

    @Override
    @ThrowSafe
    public void handleEmailTemplatesRevertedEvent(EmailTemplatesRevertedEvent event) {
        if (event.isOperationSuccessful()) {
            this.auditService.audit(AuditEvent.builder((AuditType)EMAIL_TEMPLATES_REVERTED).build());
        }
    }
}

