/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.jira.auditing.AffectedGeneralConfigurationOption;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.GeneralConfigurationChangesEventHandler;
import com.atlassian.jira.event.property.BooleanApplicationPropertySetEvent;
import com.atlassian.jira.util.I18nHelper;

public class GeneralConfigurationChangesEventHandlerImpl
implements GeneralConfigurationChangesEventHandler {
    private final I18nHelper i18n;

    public GeneralConfigurationChangesEventHandlerImpl(I18nHelper i18n) {
        this.i18n = i18n;
    }

    @Override
    public RecordRequest onGeneralConfigurationChanged(BooleanApplicationPropertySetEvent event) {
        if ("jira.option.allowunassigned".equals(event.getPropertyKey())) {
            String optionName = this.i18n.getText("admin.generalconfiguration.allow.unassigned.issues");
            return this.onConfigurationOptionToggled(event, optionName);
        }
        return null;
    }

    private RecordRequest onConfigurationOptionToggled(BooleanApplicationPropertySetEvent event, String optionName) {
        String enabled = this.i18n.getText("common.concepts.enabled");
        String disabled = this.i18n.getText("common.concepts.disabled");
        String from = (Boolean)event.getPropertyValue() != false ? disabled : enabled;
        String to = (Boolean)event.getPropertyValue() != false ? enabled : disabled;
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.add(optionName, from, to);
        return new RecordRequest(AuditingCategory.GENERAL_CONFIGURATION, "jira.auditing.configuration.option.changed").withActionI18nKey("jira.auditing.configuration.option.changed").forObject((AssociatedItem)new AffectedGeneralConfigurationOption(optionName)).withChangedValues(changedValues.build());
    }
}

