/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.PrioritySchemeAuditHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.project.Project;
import java.util.Set;
import java.util.stream.Collectors;

@AuditExceptionSafe
public final class PrioritySchemeAuditHandlerImpl
implements PrioritySchemeAuditHandler {
    private static final String I18N_PROJECT_ASSIGNED = "jira.auditing.priority.scheme.association.changed.assigned";
    private static final String I18N_PROJECT_UNASSIGNED = "jira.auditing.priority.scheme.association.changed.unassigned";
    private static final AuditType PRIORITY_SCHEME_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.FIELD_CONFIG_SCHEME, "jira.auditing.priority.scheme.created", CoverageLevel.ADVANCED);
    private static final AuditType PRIORITY_SCHEME_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.FIELD_CONFIG_SCHEME, "jira.auditing.priority.scheme.updated", CoverageLevel.ADVANCED);
    private static final AuditType PRIORITY_SCHEME_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.FIELD_CONFIG_SCHEME, "jira.auditing.priority.scheme.deleted", CoverageLevel.ADVANCED);
    private static final AuditType PRIORITY_SCHEME_ASSOCIATION_CHANGED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.FIELD_CONFIG_SCHEME, "jira.auditing.priority.scheme.association.changed", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public PrioritySchemeAuditHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handlePrioritySchemeCreated(FieldConfigScheme fieldConfigScheme) {
        AuditEvent auditEvent = AuditEvent.builder((AuditType)PRIORITY_SCHEME_CREATED).affectedObject(AuditResource.builder((String)fieldConfigScheme.getName(), (String)AssociatedItem.Type.FIELD_CONFIG_SCHEME.name()).id(fieldConfigScheme.getId().toString()).build()).changedValues(new ChangedValuesBuilder().add("jira.auditing.priority.scheme.name", fieldConfigScheme.getName()).add("jira.auditing.priority.scheme.description", fieldConfigScheme.getDescription()).build()).build();
        this.auditService.audit(auditEvent);
    }

    @Override
    @ThrowSafe
    public void handlePrioritySchemeUpdated(FieldConfigScheme fieldConfigScheme) {
        AuditEvent auditEvent = AuditEvent.builder((AuditType)PRIORITY_SCHEME_UPDATED).affectedObject(AuditResource.builder((String)fieldConfigScheme.getName(), (String)AssociatedItem.Type.FIELD_CONFIG_SCHEME.name()).id(fieldConfigScheme.getId().toString()).build()).changedValues(new ChangedValuesBuilder().add("jira.auditing.priority.scheme.name", fieldConfigScheme.getName()).add("jira.auditing.priority.scheme.description", fieldConfigScheme.getDescription()).build()).build();
        this.auditService.audit(auditEvent);
    }

    @Override
    @ThrowSafe
    public void handlePrioritySchemeDeleted(FieldConfigScheme fieldConfigScheme) {
        AuditEvent auditEvent = AuditEvent.builder((AuditType)PRIORITY_SCHEME_DELETED).affectedObject(AuditResource.builder((String)fieldConfigScheme.getName(), (String)AssociatedItem.Type.FIELD_CONFIG_SCHEME.name()).id(fieldConfigScheme.getId().toString()).build()).build();
        this.auditService.audit(auditEvent);
    }

    @Override
    @ThrowSafe
    public void handlePrioritySchemeAssociationAdded(FieldConfigScheme fieldConfigScheme, Set<Project> projects) {
        this.handlePrioritySchemeAssociationsChanged(fieldConfigScheme, projects, I18N_PROJECT_ASSIGNED);
    }

    @Override
    @ThrowSafe
    public void handlePrioritySchemeAssociationDeleted(FieldConfigScheme fieldConfigScheme, Set<Project> projects) {
        this.handlePrioritySchemeAssociationsChanged(fieldConfigScheme, projects, I18N_PROJECT_UNASSIGNED);
    }

    private void handlePrioritySchemeAssociationsChanged(FieldConfigScheme fieldConfigScheme, Set<Project> projects, String i18nAction) {
        Set namesOfAffectedProjects = projects.stream().map(Project::getName).collect(Collectors.toSet());
        AuditEvent auditEvent = AuditEvent.builder((AuditType)PRIORITY_SCHEME_ASSOCIATION_CHANGED).changedValues(new ChangedValuesBuilder().add(i18nAction, namesOfAffectedProjects.toString()).build()).affectedObject(AuditResource.builder((String)fieldConfigScheme.getName(), (String)AssociatedItem.Type.SCHEME.toString()).id(fieldConfigScheme.getId().toString()).build()).build();
        this.auditService.audit(auditEvent);
    }
}

