/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.handlers.TimeTrackingHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import javax.annotation.Nonnull;

@AuditExceptionSafe
public class TimeTrackingHandlerImpl
implements TimeTrackingHandler {
    private static final AuditType TIME_TRACKING_ENABLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.GENERAL_CONFIGURATION, "jira.auditing.time.tracking.enabled", CoverageLevel.ADVANCED);
    private static final AuditType TIME_TRACKING_DISABLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.GENERAL_CONFIGURATION, "jira.auditing.time.tracking.disabled", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public TimeTrackingHandlerImpl(@Nonnull AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleTimeTrackingEnabled(TimeTrackingHandler.TimeTrackingHandlerData data) {
        this.auditService.audit(AuditEvent.builder((AuditType)TIME_TRACKING_ENABLED).changedValues(data.toChangeValuesEnabled()).build());
    }

    @Override
    @ThrowSafe
    public void handleTimeTrackingDisabled(TimeTrackingHandler.TimeTrackingHandlerData data) {
        this.auditService.audit(AuditEvent.builder((AuditType)TIME_TRACKING_DISABLED).changedValues(data.toChangeValuesDisabled()).build());
    }
}

