/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.service;

import com.atlassian.audit.core.spi.AuditMethods;
import com.atlassian.audit.core.spi.service.AuditMethodProvider;
import com.atlassian.jira.security.plugin.ScopesRequestCacheDelegate;
import com.atlassian.sal.api.web.context.HttpContext;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class JiraAuditMethodProviderImpl
implements AuditMethodProvider {
    @VisibleForTesting
    static final String HEADER_MOBILE_APP_REQUEST = "mobile-app-request";
    @VisibleForTesting
    static final String AUDIT_METHOD_TASK = "Task";
    @VisibleForTesting
    static final String OAUTH_METHOD = "OAuth";
    private final HttpContext httpContext;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;

    public JiraAuditMethodProviderImpl(HttpContext httpContext, ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        this.httpContext = httpContext;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    @Nonnull
    public String currentMethod() {
        try {
            HttpServletRequest request = this.httpContext.getRequest();
            Optional<String> oauth2ApplicationName = this.scopesRequestCacheDelegate.getApplicationNameForRequest();
            if (oauth2ApplicationName.isPresent()) {
                return this.getOAuthMethod(request, oauth2ApplicationName.get());
            }
            if (Thread.currentThread().getName().startsWith("JiraTaskExecutionThread-")) {
                return AUDIT_METHOD_TASK;
            }
            if (request == null) {
                return AuditMethods.system();
            }
            if (this.isMobileAppRequest(request)) {
                return AuditMethods.mobile();
            }
            return AuditMethods.browser();
        }
        catch (IllegalStateException ise) {
            return AuditMethods.unknown();
        }
    }

    private String getOAuthMethod(HttpServletRequest request, String oauth2ApplicationName) {
        String applicationName = this.isMobileAppRequest(request) ? AuditMethods.mobile() : oauth2ApplicationName;
        return applicationName + " - " + OAUTH_METHOD;
    }

    private boolean isMobileAppRequest(HttpServletRequest request) {
        return request != null && request.getHeader(HEADER_MOBILE_APP_REQUEST) != null;
    }
}

