/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFilenames;
import com.atlassian.jira.avatar.AvatarImageDataProvider;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.config.util.FileStores;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class AvatarImageDataStorage {
    static final String AVATAR_DIRECTORY = "data/avatars";
    private final FileStores fileStores;
    private final EventPublisher eventPublisher;

    public AvatarImageDataStorage(FileStores fileStores, EventPublisher eventPublisher) {
        this.fileStores = fileStores;
        this.eventPublisher = eventPublisher;
    }

    public String getNextFilenameStub() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAvatarFiles(Avatar avatar, AvatarImageDataProvider imageDataProvider) throws IOException {
        ArrayList createFiles = Lists.newArrayList();
        try {
            for (Avatar.Size size : Avatar.Size.values()) {
                File file = this.createAvatarFile(avatar, size);
                createFiles.add(file);
                try (FileOutputStream output = new FileOutputStream(file);){
                    imageDataProvider.storeImage(size, (OutputStream)output);
                }
            }
        }
        catch (IOException e) {
            this.cleanup(createFiles);
            throw e;
        }
        catch (RuntimeException e) {
            this.cleanup(createFiles);
            throw e;
        }
        this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_ADD, JiraHomeChangeEvent.FileType.AVATAR, createFiles.toArray(new File[createFiles.size()])));
    }

    private void cleanup(List<File> files) {
        for (File file : files) {
            file.delete();
        }
    }

    public File createAvatarFile(Avatar avatar, Avatar.Size size) throws IOException {
        File base = this.getAvatarBaseDirectory();
        this.createDirectoryIfAbsent(base);
        return new File(base, AvatarFilenames.getAvatarFilename(avatar, size));
    }

    public File getAvatarBaseDirectory() {
        return this.fileStores.getHomeFilesystemPath().path(new String[]{AVATAR_DIRECTORY}).asJavaFile();
    }

    private void createDirectoryIfAbsent(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Avatars directory is absent and I'm unable to create it. '" + dir.getAbsolutePath() + "'");
        }
        if (!dir.isDirectory()) {
            throw new IllegalStateException("Avatars directory cannot be created due to an existing file. '" + dir.getAbsolutePath() + "'");
        }
    }
}

