/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar.types;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImageDataProvider;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.SystemAndCustomAvatars;
import com.atlassian.jira.avatar.TypeAvatarService;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.user.ApplicationUser;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class BasicTypedTypeAvatarService
implements TypeAvatarService {
    private final IconType iconType;
    private final AvatarManager avatarManager;

    public BasicTypedTypeAvatarService(IconType iconType, AvatarManager avatarManager) {
        this.iconType = iconType;
        this.avatarManager = avatarManager;
    }

    public final SystemAndCustomAvatars getAvatars(ApplicationUser remoteUser, String owningObjectId) {
        List systemAvatars = this.avatarManager.getAllSystemAvatars(this.iconType);
        List avatarsForOwner = this.avatarManager.getCustomAvatarsForOwner(this.iconType, owningObjectId);
        return new SystemAndCustomAvatars(systemAvatars, avatarsForOwner);
    }

    public Avatar getAvatar(ApplicationUser remoteUser, long avatarId) {
        Avatar currentAvatar = this.avatarManager.getById(Long.valueOf(avatarId));
        boolean userCanViewAvatar = currentAvatar != null ? this.avatarManager.userCanView(remoteUser, currentAvatar) : false;
        return userCanViewAvatar ? currentAvatar : null;
    }

    public boolean canUserCreateAvatar(ApplicationUser remoteUser, String owningObjectId) {
        return this.avatarManager.userCanCreateFor(remoteUser, this.iconType, new IconOwningObjectId(owningObjectId));
    }

    public Avatar createAvatar(ApplicationUser remoteUser, String owningObjectId, AvatarImageDataProvider imageDataProvider) throws IllegalAccessException, IOException {
        if (!this.avatarManager.userCanCreateFor(remoteUser, this.iconType, new IconOwningObjectId(owningObjectId))) {
            throw new IllegalAccessException();
        }
        return this.avatarManager.create(this.iconType, new IconOwningObjectId(owningObjectId), imageDataProvider);
    }

    @Nonnull
    public Avatar getDefaultAvatar() {
        Long defaultAvatarId = this.avatarManager.getDefaultAvatarId(this.iconType);
        if (null == defaultAvatarId) {
            throw new NoSuchElementException("No default avatar id for " + this.iconType);
        }
        Avatar avatar = this.avatarManager.getById(defaultAvatarId);
        if (null == avatar) {
            throw new NoSuchElementException("No default avatar for " + this.iconType);
        }
        return avatar;
    }
}

