/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.customfield;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomFieldVisibilityCheck {
    private final FieldManager fieldManager;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;

    public CustomFieldVisibilityCheck(FieldManager fieldManager, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager) {
        this.fieldManager = fieldManager;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
    }

    public boolean isCustomFieldVisibleForUser(@Nullable ApplicationUser user, @Nonnull CustomField field) {
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return true;
        }
        if (this.fieldManager.isFieldHidden(user, (Field)field)) {
            return false;
        }
        if (field.isAllProjects()) {
            return this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, user);
        }
        return field.getAssociatedProjectObjects().stream().anyMatch(project -> this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user));
    }
}

