/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.util;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.issue.util.VisibilityValidator;
import com.atlassian.jira.bc.issue.visibility.GroupVisibility;
import com.atlassian.jira.bc.issue.visibility.InvalidVisibility;
import com.atlassian.jira.bc.issue.visibility.PublicVisibility;
import com.atlassian.jira.bc.issue.visibility.RoleVisibility;
import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.bc.issue.visibility.VisibilityVisitor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.ErrorCollection;
import io.atlassian.fugue.Option;

public class DefaultVisibilityValidator
implements VisibilityValidator {
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectRoleManager projectRoleManager;
    private final GroupManager groupManager;

    public DefaultVisibilityValidator(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, ProjectRoleManager projectRoleManager, GroupManager groupManager) {
        this.applicationProperties = applicationProperties;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectRoleManager = projectRoleManager;
        this.groupManager = groupManager;
    }

    public boolean isValidVisibilityData(JiraServiceContext jiraServiceContext, String i18nPrefix, Issue issue, String groupLevel, String roleLevelId) {
        return this.isValidVisibilityData(jiraServiceContext, i18nPrefix, issue, Visibilities.fromGroupAndStrRoleId((String)groupLevel, (String)roleLevelId));
    }

    public boolean isValidVisibilityData(JiraServiceContext jiraServiceContext, String i18nPrefix, Issue issue, Visibility visibility) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        Option<String> nonFiledSpecificError = this.findNonFiledSpecificError(jiraServiceContext, i18nPrefix, issue, visibility);
        if (nonFiledSpecificError.isDefined()) {
            errorCollection.addErrorMessage((String)nonFiledSpecificError.get(), ErrorCollection.Reason.VALIDATION_FAILED);
            return false;
        }
        Option<String> fieldSpecificError = this.findFieldSpecificError(jiraServiceContext, i18nPrefix, issue, visibility);
        if (fieldSpecificError.isDefined()) {
            errorCollection.addError("commentLevel", (String)fieldSpecificError.get(), ErrorCollection.Reason.VALIDATION_FAILED);
            return false;
        }
        return true;
    }

    private Option<String> findNonFiledSpecificError(final JiraServiceContext jiraServiceContext, final String i18nPrefix, Issue issue, Visibility visibility) {
        if (issue == null) {
            return Option.some((Object)this.getText(i18nPrefix + ".service.error.issue.null"));
        }
        return (Option)visibility.accept((VisibilityVisitor)new VisibilityVisitor<Option<String>>(){

            public Option<String> visit(PublicVisibility publicVisibility) {
                return Option.none();
            }

            public Option<String> visit(RoleVisibility roleVisibility) {
                return this.getErrorOnAnonymousUser();
            }

            public Option<String> visit(GroupVisibility groupVisibility) {
                return this.getErrorOnAnonymousUser();
            }

            public Option<String> visit(InvalidVisibility invalidVisibility) {
                return Option.none();
            }

            private Option<String> getErrorOnAnonymousUser() {
                if (Users.isAnonymous((ApplicationUser)jiraServiceContext.getLoggedInApplicationUser())) {
                    return Option.some((Object)DefaultVisibilityValidator.this.getText(i18nPrefix + ".service.error.visibility.anonymous"));
                }
                return Option.none();
            }
        });
    }

    private Option<String> findFieldSpecificError(final JiraServiceContext jiraServiceContext, final String i18nPrefix, final Issue issue, Visibility visibility) {
        return (Option)visibility.accept((VisibilityVisitor)new VisibilityVisitor<Option<String>>(){

            public Option<String> visit(PublicVisibility publicVisibility) {
                return Option.none();
            }

            public Option<String> visit(RoleVisibility roleVisibility) {
                if (!DefaultVisibilityValidator.this.isProjectRoleVisibilityEnabled()) {
                    return Option.some((Object)DefaultVisibilityValidator.this.getText(i18nPrefix + ".service.error.visibility.role"));
                }
                ProjectRole projectRole = DefaultVisibilityValidator.this.projectRoleManager.getProjectRole(roleVisibility.getRoleLevelId());
                if (projectRole == null) {
                    return Option.some((Object)DefaultVisibilityValidator.this.getText(i18nPrefix + ".service.error.roledoesnotexist", roleVisibility.getRoleLevelId().toString()));
                }
                ApplicationUser currentUser = jiraServiceContext.getLoggedInApplicationUser();
                if (!DefaultVisibilityValidator.this.projectRoleManager.isUserInProjectRole(currentUser, projectRole, issue.getProjectObject())) {
                    return Option.some((Object)DefaultVisibilityValidator.this.getText(i18nPrefix + ".service.error.usernotinrole", projectRole.getName()));
                }
                return Option.none();
            }

            public Option<String> visit(GroupVisibility groupVisibility) {
                if (!DefaultVisibilityValidator.this.isGroupVisibilityEnabled()) {
                    return Option.some((Object)DefaultVisibilityValidator.this.getText(i18nPrefix + ".service.error.visibility.group"));
                }
                String groupLevel = groupVisibility.getGroupLevel();
                if (!DefaultVisibilityValidator.this.groupManager.groupExists(groupLevel)) {
                    return Option.some((Object)DefaultVisibilityValidator.this.getText(i18nPrefix + ".service.error.groupdoesnotexist", groupLevel));
                }
                ApplicationUser currentUser = jiraServiceContext.getLoggedInApplicationUser();
                if (!DefaultVisibilityValidator.this.groupManager.isUserInGroup(currentUser, groupLevel)) {
                    return Option.some((Object)DefaultVisibilityValidator.this.getText(i18nPrefix + ".service.error.usernotingroup", groupLevel));
                }
                return Option.none();
            }

            public Option<String> visit(InvalidVisibility invalidVisibility) {
                if (invalidVisibility.getParam().isDefined()) {
                    return Option.some((Object)DefaultVisibilityValidator.this.getText(i18nPrefix + '.' + invalidVisibility.getI18nErrorMessage(), (String)invalidVisibility.getParam().get()));
                }
                return Option.some((Object)DefaultVisibilityValidator.this.getText(i18nPrefix + '.' + invalidVisibility.getI18nErrorMessage()));
            }
        });
    }

    public boolean isGroupVisiblityEnabled() {
        return this.isGroupVisibilityEnabled();
    }

    public boolean isProjectRoleVisiblityEnabled() {
        return this.isProjectRoleVisibilityEnabled();
    }

    public boolean isGroupVisibilityEnabled() {
        return this.applicationProperties.getOption("jira.comment.level.visibility.groups");
    }

    public boolean isProjectRoleVisibilityEnabled() {
        return true;
    }

    private String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }

    private String getText(String key, String param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }
}

