/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.auditing.handlers.AccessDeniedAuditHandler;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.DeleteProjectCommand;
import com.atlassian.jira.bc.project.DeleteProjectTaskContext;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectNameValidator;
import com.atlassian.jira.bc.project.ProjectSchemeAssociationManager;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.ProjectTypeValidator;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.ProjectCategoryFactory;
import com.atlassian.jira.event.project.ProjectEventManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectCreateNotifier;
import com.atlassian.jira.project.ProjectCreatedData;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.UpdateProjectParameters;
import com.atlassian.jira.project.template.ProjectTemplate;
import com.atlassian.jira.project.template.ProjectTemplateKey;
import com.atlassian.jira.project.template.ProjectTemplateManager;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeUpdatedNotifier;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermissionDeleteUtils;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.opensymphony.util.TextUtils;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProjectService
implements ProjectService {
    private static final int MAX_FIELD_LENGTH = 255;
    private static final int DEFAULT_KEY_LENGTH = 10;
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectService.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectManager projectManager;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final SchemeFactory schemeFactory;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final CustomFieldManager customFieldManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final VersionManager versionManager;
    private final ProjectComponentManager projectComponentManager;
    private final SharePermissionDeleteUtils sharePermissionDeleteUtils;
    private final AvatarManager avatarManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final WorkflowManager workflowManager;
    private final UserManager userManager;
    private final ProjectEventManager projectEventManager;
    private final ProjectKeyStore projectKeyStore;
    private final ProjectNameValidator projectNameValidator;
    private final AccessDeniedAuditHandler auditHandler;
    private final ProjectTypeValidator projectTypeValidator;
    private final ProjectTypeUpdatedNotifier projectTypeUpdatedNotifier;
    private final ProjectCreateNotifier projectCreateNotifier;
    private final ClusterLockService clusterLockService;
    private final ProjectTemplateManager projectTemplateManager;
    private final ProjectSchemeAssociationManager projectSchemeAssociationManager;
    private final TaskManager taskManager;
    private final IssueManager issueManager;

    public DefaultProjectService(JiraAuthenticationContext jiraAuthenticationContext, ProjectManager projectManager, ApplicationProperties applicationProperties, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager, PermissionSchemeManager permissionSchemeManager, NotificationSchemeManager notificationSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, SchemeFactory schemeFactory, WorkflowSchemeManager workflowSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, CustomFieldManager customFieldManager, NodeAssociationStore nodeAssociationStore, VersionManager versionManager, ProjectComponentManager projectComponentManager, SharePermissionDeleteUtils sharePermissionDeleteUtils, AvatarManager avatarManager, I18nHelper.BeanFactory i18nFactory, WorkflowManager workflowManager, UserManager userManager, ProjectEventManager projectEventManager, ProjectKeyStore projectKeyStore, ProjectTypeValidator projectTypeValidator, ProjectCreateNotifier projectCreateNotifier, ProjectTypeUpdatedNotifier projectTypeUpdatedNotifier, ClusterLockService clusterLockService, ProjectTemplateManager projectTemplateManager, ProjectSchemeAssociationManager projectSchemeAssociationManager, TaskManager taskManager, IssueManager issueManager, AccessDeniedAuditHandler auditHandler) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectManager = projectManager;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.schemeFactory = schemeFactory;
        this.workflowSchemeManager = workflowSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.customFieldManager = customFieldManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.versionManager = versionManager;
        this.projectComponentManager = projectComponentManager;
        this.sharePermissionDeleteUtils = sharePermissionDeleteUtils;
        this.avatarManager = avatarManager;
        this.i18nFactory = i18nFactory;
        this.workflowManager = workflowManager;
        this.userManager = userManager;
        this.projectEventManager = projectEventManager;
        this.projectKeyStore = projectKeyStore;
        this.projectTypeValidator = projectTypeValidator;
        this.projectCreateNotifier = projectCreateNotifier;
        this.projectTypeUpdatedNotifier = projectTypeUpdatedNotifier;
        this.clusterLockService = clusterLockService;
        this.projectTemplateManager = projectTemplateManager;
        this.projectSchemeAssociationManager = projectSchemeAssociationManager;
        this.taskManager = taskManager;
        this.issueManager = issueManager;
        this.auditHandler = auditHandler;
        this.projectNameValidator = new ProjectNameValidator(this, projectManager);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String key, String description, ApplicationUser lead, String url, Long assigneeType) {
        return this.validateUpdateProject(user, name, key, description, this.nameFor(lead), url, assigneeType);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String key, String description, ApplicationUser lead, String url, Long assigneeType, Long avatarId) {
        return this.validateUpdateProject(user, name, key, description, this.nameFor(lead), url, assigneeType, avatarId);
    }

    public ProjectService.DeleteProjectValidationResult validateDeleteProject(ApplicationUser user, String key) {
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return new ProjectService.DeleteProjectValidationResult(ErrorCollections.create((String)i18nBean.getText("admin.projects.service.error.no.admin.permission"), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN));
        }
        ProjectService.GetProjectResult oldProjectResult = this.getProjectByKeyForAction(user, key, ProjectAction.DELETE_PROJECT);
        if (!oldProjectResult.isValid() || oldProjectResult.getProject() == null) {
            return new ProjectService.DeleteProjectValidationResult(ErrorCollections.copyOf((ErrorCollection)oldProjectResult.getErrorCollection()));
        }
        return new ProjectService.DeleteProjectValidationResult(ErrorCollections.empty(), oldProjectResult.getProject());
    }

    public ProjectService.DeleteProjectResult deleteProject(ApplicationUser user, ProjectService.DeleteProjectValidationResult deleteProjectValidationResult) {
        if (deleteProjectValidationResult == null) {
            throw new IllegalArgumentException("You can not delete a project with a null validation result.");
        }
        if (!deleteProjectValidationResult.isValid()) {
            throw new IllegalStateException("You can not delete a project with an invalid validation result.");
        }
        DeleteProjectCommand deleteProjectCommand = new DeleteProjectCommand(this.projectManager, this.workflowSchemeManager, this.issueTypeScreenSchemeManager, this.customFieldManager, this.nodeAssociationStore, this.versionManager, this.projectComponentManager, this.sharePermissionDeleteUtils, this.i18nFactory, this.workflowManager, this.permissionSchemeManager, this.projectEventManager, this.issueManager, user, deleteProjectValidationResult.getProject());
        deleteProjectCommand.setTaskProgressSink(TaskProgressSink.NULL_SINK);
        return deleteProjectCommand.call();
    }

    public ProjectService.DeleteProjectResult deleteProjectAsynchronous(ApplicationUser user, ProjectService.DeleteProjectValidationResult deleteProjectValidationResult) {
        if (deleteProjectValidationResult == null) {
            throw new IllegalArgumentException("You can not delete a project with a null validation result.");
        }
        if (!deleteProjectValidationResult.isValid()) {
            throw new IllegalStateException("You can not delete a project with an invalid validation result.");
        }
        Project project = deleteProjectValidationResult.getProject();
        String taskName = this.getI18nBean(user).getText("admin.projects.delete.project.progress", project.getName());
        DeleteProjectCommand command = new DeleteProjectCommand(this.projectManager, this.workflowSchemeManager, this.issueTypeScreenSchemeManager, this.customFieldManager, this.nodeAssociationStore, this.versionManager, this.projectComponentManager, this.sharePermissionDeleteUtils, this.i18nFactory, this.workflowManager, this.permissionSchemeManager, this.projectEventManager, this.issueManager, user, deleteProjectValidationResult.getProject());
        String progressURL = this.taskManager.submitTask(command, taskName, new DeleteProjectTaskContext(project), true).getProgressURL();
        return new ProjectService.DeleteProjectResult(progressURL);
    }

    public ProjectService.GetProjectResult getProjectById(Long id) {
        return this.getProjectById(this.jiraAuthenticationContext.getUser(), id);
    }

    public ProjectService.GetProjectResult getProjectByKey(String key) {
        return this.getProjectByKey(this.jiraAuthenticationContext.getUser(), key);
    }

    @Nonnull
    public ProjectService.CreateProjectValidationResult validateCreateProject(ApplicationUser user, @Nonnull ProjectCreationData projectCreationData) {
        JiraServiceContext serviceContext = this.getServiceContext(user, ErrorCollections.empty());
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            serviceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.projects.service.error.no.admin.permission"), ErrorCollection.Reason.FORBIDDEN);
            return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection());
        }
        ProjectCreationData projectCreationDataWithType = this.setProjectTypeFromTemplateIfNonePresent(projectCreationData);
        this.isValidAllProjectData(serviceContext, projectCreationDataWithType);
        if (serviceContext.getErrorCollection().hasAnyErrors()) {
            return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection());
        }
        return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection(), user, projectCreationDataWithType);
    }

    private ProjectCreationData setProjectTypeFromTemplateIfNonePresent(ProjectCreationData projectCreationData) {
        ProjectTypeKey projectTypeKey = projectCreationData.getProjectTypeKey();
        if (projectTypeKey != null && projectTypeKey.getKey() != null) {
            return projectCreationData;
        }
        Optional projectTemplate = this.projectTemplateManager.getProjectTemplate(projectCreationData.getProjectTemplateKey());
        if (!projectTemplate.isPresent()) {
            return projectCreationData;
        }
        ProjectTypeKey newProjectTypeKey = ((ProjectTemplate)projectTemplate.get()).getProjectTypeKey();
        return new ProjectCreationData.Builder().from(projectCreationData).withType(newProjectTypeKey).build();
    }

    @Nonnull
    public ProjectService.CreateProjectValidationResult validateCreateProjectBasedOnExistingProject(ApplicationUser user, @Nonnull Long existingProjectId, @Nonnull ProjectCreationData input) {
        JiraServiceContext serviceContext = this.getServiceContext(user, ErrorCollections.empty());
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            serviceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.projects.service.error.no.admin.permission"), ErrorCollection.Reason.FORBIDDEN);
            return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection());
        }
        ProjectService.GetProjectResult projectById = this.getProjectByIdForAction(user, existingProjectId, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!projectById.isValid()) {
            return new ProjectService.CreateProjectValidationResult(projectById.getErrorCollection());
        }
        ProjectCreationData creationData = new ProjectCreationData.Builder().fromExistingProject(projectById.get(), input).build();
        this.isValidAllProjectData(serviceContext, creationData);
        return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection(), user, creationData, Optional.of(existingProjectId));
    }

    protected JiraServiceContext getServiceContext(ApplicationUser user, ErrorCollection errorCollection) {
        return new JiraServiceContextImpl(user, errorCollection);
    }

    public Project createProject(ProjectService.CreateProjectValidationResult result) {
        Consumer<Project> projectConsumer = this.shouldCreateProjectBasedOnExisting(result) ? newProject -> {
            Optional<Project> existing = Optional.ofNullable(this.projectManager.getProjectObj((Long)result.getExistingProjectId().get()));
            Project existingProject = existing.orElseThrow(() -> new IllegalStateException("Could not retrieve existing project."));
            Optional<ProjectCategory> projectCategory = Optional.ofNullable(existingProject.getProjectCategory());
            projectCategory.ifPresent(category -> this.projectManager.setProjectCategory(newProject, category));
            this.projectSchemeAssociationManager.associateSchemesOfExistingProjectWithNewProject((Project)newProject, existingProject);
        } : this.projectSchemeAssociationManager::associateDefaultSchemesWithProject;
        return this.createProjectInternal(result, projectConsumer);
    }

    private Project createProjectInternal(ProjectService.CreateProjectValidationResult result, Consumer<Project> projectConsumer) {
        if (result == null) {
            throw new IllegalArgumentException("You can not create a project with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not create a project with an invalid validation result.");
        }
        if (result.getExistingProjectId().isPresent()) {
            Optional.ofNullable(this.projectManager.getProjectObj((Long)result.getExistingProjectId().get())).orElseThrow(() -> new IllegalStateException("Existing project could not be found."));
        }
        ApplicationUser user = result.getUser();
        ProjectCreationData projectCreationData = result.getProjectCreationData();
        Project newProject = this.projectManager.createProject(user, new ProjectCreationData.Builder().from(projectCreationData).withKey(projectCreationData.getKey().toUpperCase()).withLead(projectCreationData.getLead()).withAssigneeType(this.effectiveAssigneeType(projectCreationData.getAssigneeType())).build());
        projectConsumer.accept(newProject);
        this.workflowSchemeManager.clearWorkflowCache();
        this.notifyHandlersOfProjectCreated(user, newProject, result);
        this.projectEventManager.dispatchProjectCreated(user, newProject);
        return newProject;
    }

    private boolean shouldCreateProjectBasedOnExisting(ProjectService.CreateProjectValidationResult result) {
        return result != null && result.getExistingProjectId().isPresent();
    }

    private void notifyHandlersOfProjectCreated(ApplicationUser user, Project newProject, ProjectService.CreateProjectValidationResult result) {
        ProjectCreatedData.Builder projectCreatedData = new ProjectCreatedData.Builder().withProject(newProject);
        Optional.ofNullable(result.getProjectCreationData().getProjectTemplateKey()).ifPresent(arg_0 -> ((ProjectCreatedData.Builder)projectCreatedData).withProjectTemplateKey(arg_0));
        result.getExistingProjectId().ifPresent(arg_0 -> ((ProjectCreatedData.Builder)projectCreatedData).withExistingProjectId(arg_0));
        boolean notificationWasSuccessful = this.projectCreateNotifier.notifyAllHandlers(projectCreatedData.build());
        if (!notificationWasSuccessful) {
            this.deleteProject(user, new ProjectService.DeleteProjectValidationResult(ErrorCollections.empty(), newProject));
            throw new RuntimeException("An error occurred while notifying that a project was created");
        }
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String key, String description, String leadName, String url, Long assigneeType) {
        return this.validateUpdateProject(user, name, key, description, leadName, url, assigneeType, null);
    }

    public ServiceResult validateUpdateProject(ApplicationUser user, String key) {
        ProjectService.GetProjectResult oldProjectResult = this.getProjectByKeyForAction(user, key, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!oldProjectResult.isValid()) {
            return new ServiceResultImpl(ErrorCollections.copyOf((ErrorCollection)oldProjectResult.getErrorCollection()));
        }
        return new ServiceResultImpl(ErrorCollections.empty());
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser applicationUser, Project originalProject, String name, String key, String description, ApplicationUser lead, String url, Long assigneeType, Long avatarId) {
        return this.validateUpdateProject(applicationUser, originalProject, name, key, description, this.nameFor(lead), url, assigneeType, avatarId);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser applicationUser, Project originalProject, String name, String key, String description, String leadName, String url, Long assigneeType, Long avatarId) {
        return this.validateUpdateProject(applicationUser, name, originalProject.getKey(), key, description, leadName, url, assigneeType, avatarId);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String key, String description, String leadName, String url, Long assigneeType, Long avatarId) {
        return this.validateUpdateProject(user, name, key, key, description, leadName, url, assigneeType, avatarId);
    }

    private ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String oldKey, String newKey, String description, String leadUsername, String url, Long assigneeType, Long avatarId) {
        ApplicationUser lead;
        ProjectService.GetProjectResult getProjectResult = this.getProjectByKeyForAction(user, oldKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!getProjectResult.isValid()) {
            return new ProjectService.UpdateProjectValidationResult(ErrorCollections.copyOf((ErrorCollection)getProjectResult.getErrorCollection()));
        }
        Project project = getProjectResult.getProject();
        ErrorCollection validationErrors = this.validateUpdateProjectData(user, name, project, lead = this.getUserByName(leadUsername), url, assigneeType, avatarId);
        if (validationErrors.hasAnyErrors()) {
            return new ProjectService.UpdateProjectValidationResult(validationErrors);
        }
        ProjectService.UpdateProjectRequest updateProjectRequest = new ProjectService.UpdateProjectRequest(project);
        updateProjectRequest.name(name).key(newKey).description(description).leadUsername(leadUsername).url(url).assigneeType(assigneeType).avatarId(avatarId);
        return this.validateUpdateProject(user, updateProjectRequest);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, ProjectService.UpdateProjectRequest updateProjectRequest) {
        if (user == null) {
            throw new IllegalArgumentException("You can not update a project with a null user.");
        }
        I18nHelper i18nHelper = this.getI18nBean(user);
        UpdateProjectParameters projectParameters = updateProjectRequest.getUpdateProjectParameters();
        ProjectService.GetProjectResult getProjectResult = this.getProjectByIdForAction(user, projectParameters.getProjectId(), ProjectAction.EDIT_PROJECT_CONFIG);
        if (!getProjectResult.isValid()) {
            return new ProjectService.UpdateProjectValidationResult(ErrorCollections.copyOf((ErrorCollection)getProjectResult.getErrorCollection()));
        }
        Project project = getProjectResult.getProject();
        ErrorCollection errors = this.validateUpdateProjectParameters(user, project, projectParameters);
        if (errors.hasAnyErrors()) {
            return new ProjectService.UpdateProjectValidationResult(errors);
        }
        return new ProjectService.UpdateProjectValidationResult(errors, project, user, updateProjectRequest);
    }

    public Project updateProject(ProjectService.UpdateProjectValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not update a project with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not update a project with an invalid validation result.");
        }
        ApplicationUser user = result.getUser();
        Project originalProject = result.getOriginalProject();
        UpdateProjectParameters updateProjectParameters = result.getUpdateProjectRequest().getUpdateProjectParameters();
        Project updatedProject = this.projectManager.updateProject(updateProjectParameters);
        Either<Project, ErrorCollection> projectTypeUpdate = Either.left((Object)updatedProject);
        if (!originalProject.getProjectTypeKey().equals((Object)updatedProject.getProjectTypeKey())) {
            projectTypeUpdate = this.notifyProjectTypeUpdated(user, updatedProject, originalProject.getProjectTypeKey(), updatedProject.getProjectTypeKey(), false);
        }
        if (projectTypeUpdate.isLeft()) {
            this.projectEventManager.dispatchProjectUpdated(user, updatedProject, originalProject, result.getUpdateProjectRequest().getRequestSourceType());
        } else {
            UpdateProjectParameters originalProjectParameters = UpdateProjectParameters.forProject((Long)updateProjectParameters.getProjectId());
            updatedProject = this.projectManager.updateProject(originalProjectParameters);
        }
        return updatedProject;
    }

    public ProjectService.UpdateProjectSchemesValidationResult validateUpdateProjectSchemes(ApplicationUser user, Long permissionSchemeId, Long notificationSchemeId, Long issueSecuritySchemeId) {
        GenericValue scheme;
        ErrorCollection errorCollection = ErrorCollections.empty();
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.projects.service.error.no.admin.permission"), ErrorCollection.Reason.VALIDATION_FAILED);
            return new ProjectService.UpdateProjectSchemesValidationResult(errorCollection);
        }
        if (permissionSchemeId != null && permissionSchemeId != -1L) {
            try {
                scheme = this.permissionSchemeManager.getScheme(permissionSchemeId);
                if (scheme == null) {
                    errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.permission.scheme.not.retrieved"), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }
            catch (GenericEntityException e) {
                errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.permission.scheme.not.retrieved.error", e.getMessage()), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        if (notificationSchemeId != null && notificationSchemeId != -1L) {
            try {
                scheme = this.notificationSchemeManager.getScheme(notificationSchemeId);
                if (scheme == null) {
                    errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.notification.scheme.not.retrieved"), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }
            catch (GenericEntityException e) {
                errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.notification.scheme.not.retrieved.error", e.getMessage()), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        if (issueSecuritySchemeId != null && issueSecuritySchemeId != -1L && (scheme = this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(issueSecuritySchemeId)) == null) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.issuesecurity.scheme.not.retrieved"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (errorCollection.hasAnyErrors()) {
            return new ProjectService.UpdateProjectSchemesValidationResult(errorCollection);
        }
        return new ProjectService.UpdateProjectSchemesValidationResult(errorCollection, permissionSchemeId, notificationSchemeId, issueSecuritySchemeId);
    }

    public void updateProjectSchemes(ProjectService.UpdateProjectSchemesValidationResult result, Project project) {
        if (result == null) {
            throw new IllegalArgumentException("You can not update project schemes with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not update project schemes with an invalid validation result.");
        }
        if (project == null) {
            throw new IllegalArgumentException("You can not update project schemes for a null project.");
        }
        Long permissionSchemeId = result.getPermissionSchemeId();
        Long notificationSchemeId = result.getNotificationSchemeId();
        Long issueSecuritySchemeId = result.getIssueSecuritySchemeId();
        try {
            Scheme currentIssueSecurityScheme;
            Scheme currentPermissionScheme;
            Scheme currentNotificationScheme = this.notificationSchemeManager.getSchemeFor(project);
            if (currentNotificationScheme == null || !currentNotificationScheme.getId().equals(notificationSchemeId)) {
                this.notificationSchemeManager.removeSchemesFromProject(project);
                if (notificationSchemeId != null && !new Long(-1L).equals(notificationSchemeId)) {
                    GenericValue scheme = this.notificationSchemeManager.getScheme(notificationSchemeId);
                    this.notificationSchemeManager.addSchemeToProject(project, this.schemeFactory.getScheme(scheme));
                }
            }
            if (!((currentPermissionScheme = this.permissionSchemeManager.getSchemeFor(project)) != null && currentPermissionScheme.getId().equals(permissionSchemeId) || permissionSchemeId == null || new Long(-1L).equals(permissionSchemeId))) {
                this.permissionSchemeManager.removeSchemesFromProject(project);
                GenericValue scheme = this.permissionSchemeManager.getScheme(permissionSchemeId);
                this.permissionSchemeManager.addSchemeToProject(project, this.schemeFactory.getScheme(scheme));
            }
            if ((currentIssueSecurityScheme = this.issueSecuritySchemeManager.getSchemeFor(project)) == null || !currentIssueSecurityScheme.getId().equals(issueSecuritySchemeId)) {
                if (new Long(-1L).equals(issueSecuritySchemeId)) {
                    issueSecuritySchemeId = null;
                }
                this.issueSecuritySchemeManager.setSchemeForProject(project, issueSecuritySchemeId);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public boolean isValidAllProjectData(JiraServiceContext serviceContext, ProjectCreationData projectCreationData) {
        ErrorCollection errorCollection = ErrorCollections.empty();
        I18nHelper i18nHelper = this.getI18nBean(serviceContext.getLoggedInApplicationUser());
        this.isValidRequiredProjectData(this.getServiceContext(serviceContext.getLoggedInApplicationUser(), errorCollection), projectCreationData);
        this.validateProjectUrl(projectCreationData.getUrl(), errorCollection, i18nHelper);
        this.validateProjectAssigneeType(projectCreationData.getAssigneeType(), errorCollection, i18nHelper);
        this.validateAvatarId(projectCreationData.getAvatarId(), this.projectManager.getProjectObjByKey(projectCreationData.getKey()), errorCollection, i18nHelper);
        this.validateProjectTypeAndTemplate(projectCreationData.getProjectTypeKey(), projectCreationData.getProjectTemplateKey(), errorCollection, i18nHelper);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection(errorCollection);
            return false;
        }
        return true;
    }

    private void validateProjectTypeAndTemplate(ProjectTypeKey projectTypeKey, ProjectTemplateKey projectTemplateKey, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (projectTemplateKey == null || projectTemplateKey.getKey() == null) {
            return;
        }
        Optional projectTemplate = this.projectTemplateManager.getProjectTemplate(projectTemplateKey);
        if (!projectTemplate.isPresent()) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.invalid.project.template"), ErrorCollection.Reason.VALIDATION_FAILED);
        } else if (!this.projectTypeMatchesProjectTemplate(projectTypeKey, (ProjectTemplate)projectTemplate.get())) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.template.type.mismatch"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private boolean projectTypeMatchesProjectTemplate(ProjectTypeKey projectTypeKey, ProjectTemplate projectTemplate) {
        return projectTemplate.getProjectTypeKey().equals((Object)projectTypeKey);
    }

    public boolean isValidRequiredProjectData(JiraServiceContext serviceContext, ProjectCreationData projectCreationData) {
        ErrorCollection errorCollection = ErrorCollections.empty();
        I18nHelper i18nBean = this.getI18nBean(serviceContext.getLoggedInApplicationUser());
        this.validateProjectName(projectCreationData.getName(), errorCollection, i18nBean);
        this.validateProjectKey(null, projectCreationData.getKey(), errorCollection, i18nBean);
        this.validateProjectLead((Option<ApplicationUser>)Option.option((Object)projectCreationData.getLead()), errorCollection, i18nBean);
        this.validateProjectType(serviceContext.getLoggedInApplicationUser(), projectCreationData.getProjectTypeKey(), errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection(errorCollection);
            return false;
        }
        return true;
    }

    public boolean isValidProjectKey(JiraServiceContext serviceContext, String key) {
        ErrorCollection errorCollection = ErrorCollections.empty();
        I18nHelper i18nBean = this.getI18nBean(serviceContext.getLoggedInApplicationUser());
        this.validateProjectKey(null, key, errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection(errorCollection);
            return false;
        }
        return true;
    }

    private ErrorCollection validateUpdateProjectParameters(ApplicationUser user, Project project, UpdateProjectParameters parameters) {
        I18nHelper i18nHelper = this.getI18nBean(user);
        ErrorCollection errors = ErrorCollections.empty();
        if (parameters.getKey().isDefined() && !((String)parameters.getKey().get()).equals(project.getKey())) {
            boolean canEditProjectKey = this.checkActionPermission(user, project, ProjectAction.EDIT_PROJECT_KEY);
            if (!canEditProjectKey) {
                errors.addErrorMessage(i18nHelper.getText(ProjectAction.EDIT_PROJECT_KEY.getErrorKey()), ErrorCollection.Reason.FORBIDDEN);
                return errors;
            }
            this.validateProjectKey(project, (String)parameters.getKey().get(), errors, i18nHelper);
            if (errors.hasAnyErrors()) {
                return errors;
            }
        }
        if (parameters.getName().isDefined()) {
            this.validateProjectNameForUpdate((String)parameters.getName().get(), project.getKey(), errors, i18nHelper);
        }
        if (parameters.getLeadUserKey().isDefined()) {
            ApplicationUser lead = this.userManager.getUserByKey((String)parameters.getLeadUserKey().get());
            this.validateProjectLead((Option<ApplicationUser>)Option.option((Object)lead), errors, i18nHelper);
        } else if (parameters.getLeadUsername().isDefined()) {
            ApplicationUser lead = this.userManager.getUserByName((String)parameters.getLeadUsername().get());
            this.validateProjectLead((Option<ApplicationUser>)Option.option((Object)lead), errors, i18nHelper);
        }
        if (parameters.getUrl().isDefined()) {
            this.validateProjectUrl((String)parameters.getUrl().get(), errors, i18nHelper);
        }
        if (parameters.getAssigneeType().isDefined()) {
            this.validateProjectAssigneeType((Long)parameters.getAssigneeType().get(), errors, i18nHelper);
        }
        if (parameters.getAvatarId().isDefined()) {
            this.validateAvatarId((Long)parameters.getAvatarId().get(), project, errors, i18nHelper);
        }
        if (parameters.getProjectTypeKey().isDefined()) {
            this.validateProjectType(user, new ProjectTypeKey((String)parameters.getProjectTypeKey().get()), errors, i18nHelper);
        }
        if (parameters.getProjectCategoryId().isDefined()) {
            this.validateProjectCategoryId((Long)parameters.getProjectCategoryId().get(), user, errors, i18nHelper);
        }
        return errors;
    }

    private ErrorCollection validateUpdateProjectData(ApplicationUser user, String name, Project oldProject, ApplicationUser lead, String url, Long assigneeType, Long avatarId) {
        ErrorCollection errorCollection = ErrorCollections.empty();
        I18nHelper i18nHelper = this.getI18nBean(user);
        this.validateProjectNameForUpdate(name, oldProject.getKey(), errorCollection, i18nHelper);
        this.validateProjectLead((Option<ApplicationUser>)Option.option((Object)lead), errorCollection, i18nHelper);
        this.validateProjectUrl(url, errorCollection, i18nHelper);
        this.validateProjectAssigneeType(assigneeType, errorCollection, i18nHelper);
        this.validateAvatarId(avatarId, oldProject, errorCollection, i18nHelper);
        return errorCollection;
    }

    public String getProjectKeyDescription() {
        String projectKeyDescription = this.applicationProperties.getDefaultBackedString("jira.projectkey.description");
        I18nHelper i18nBean = this.jiraAuthenticationContext.getI18nHelper();
        if (TextUtils.stringSet((String)projectKeyDescription)) {
            return i18nBean.getText(projectKeyDescription);
        }
        return i18nBean.getText("admin.projects.key.description");
    }

    public ProjectService.GetProjectResult getProjectByIdForAction(ApplicationUser user, Long id, ProjectAction action) {
        Project project = this.projectManager.getProjectObj(id);
        return this.checkProjectPermissionsForUser(user, action, project, String.valueOf(id), "admin.errors.project.not.found.for.id");
    }

    public ProjectService.GetProjectResult getProjectById(ApplicationUser user, Long id) {
        return this.getProjectByIdForAction(user, id, ProjectAction.VIEW_ISSUES);
    }

    public ProjectService.GetProjectResult getProjectByKeyForAction(ApplicationUser user, String key, ProjectAction action) {
        Assertions.notNull((String)"action", (Object)action);
        Project project = this.projectManager.getProjectObjByKey(key);
        return this.checkProjectPermissionsForUser(user, action, project, key, "admin.errors.project.not.found.for.key");
    }

    public ProjectService.GetProjectResult getProjectByKey(ApplicationUser user, String key) {
        return this.getProjectByKeyForAction(user, key, ProjectAction.VIEW_ISSUES);
    }

    public int getMaximumNameLength() {
        String maxStr = this.applicationProperties.getDefaultBackedString("jira.projectname.maxlength");
        try {
            return Integer.parseInt(maxStr);
        }
        catch (NumberFormatException e) {
            log.error("Unable to read the MaximalProjectNameLength value '" + maxStr + "'.  Defaulting to " + 80 + ".");
            return 80;
        }
    }

    public int getMaximumKeyLength() {
        String maxStr = this.applicationProperties.getDefaultBackedString("jira.projectkey.maxlength");
        try {
            return Integer.parseInt(maxStr);
        }
        catch (NumberFormatException e) {
            log.error("Unable to read the MaximalProjectKeyLength value '" + maxStr + "'.  Defaulting to " + 10 + ".");
            return 10;
        }
    }

    public long getProjectCount() {
        return this.projectManager.getProjectCount();
    }

    public ServiceOutcome<List<Project>> getAllProjects(ApplicationUser user) {
        return this.getAllProjectsForAction(user, ProjectAction.VIEW_ISSUES);
    }

    public ServiceOutcome<List<Project>> getAllProjectsForAction(ApplicationUser user, ProjectAction action) {
        return this.getAllProjectsForAction(user, action, true);
    }

    public ServiceOutcome<List<Project>> getAllProjectsForAction(ApplicationUser user, ProjectAction action, boolean includeArchived) {
        Stream<Project> projects = Stream.concat(this.projectManager.getProjectObjects().stream(), this.projectManager.getArchivedProjects().stream()).filter(input -> input != null && this.checkActionPermission(user, (Project)input, action));
        return new ServiceOutcomeImpl<List<Project>>(ErrorCollections.empty(), (List<Project>)projects.collect(CollectorsUtil.toImmutableList()));
    }

    public Either<Project, ErrorCollection> updateProjectType(ApplicationUser user, Project project, ProjectTypeKey newProjectType) {
        I18nHelper i18nBean = this.getI18nBean(user);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.checkActionPermission(user, project, ProjectAction.EDIT_PROJECT_CONFIG)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.type.update.no.permission"), ErrorCollection.Reason.FORBIDDEN);
        }
        this.validateProjectType(user, newProjectType, (ErrorCollection)errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            return Either.right((Object)errorCollection);
        }
        return this.executeUnderClusterLock(this.getLockNameFor(project), () -> {
            Project updatedProject = this.projectManager.updateProjectType(user, project, newProjectType);
            return this.notifyProjectTypeUpdated(user, updatedProject, project.getProjectTypeKey(), newProjectType, true);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Either<Project, ErrorCollection> executeUnderClusterLock(String lockName, Supplier<Either<Project, ErrorCollection>> supplier) {
        ClusterLock lock = this.clusterLockService.getLockForName(lockName);
        lock.lock();
        try {
            Either<Project, ErrorCollection> either = supplier.get();
            return either;
        }
        finally {
            lock.unlock();
        }
    }

    private String getLockNameFor(Project project) {
        return DefaultProjectService.class.getName() + ".updateProjectType." + project.getId();
    }

    private Either<Project, ErrorCollection> notifyProjectTypeUpdated(ApplicationUser user, Project project, ProjectTypeKey oldProjectType, ProjectTypeKey newProjectType, boolean rollback) {
        boolean notificationWasSuccessful = this.projectTypeUpdatedNotifier.notifyAllHandlers(user, project, oldProjectType, newProjectType);
        if (!notificationWasSuccessful) {
            if (rollback) {
                this.projectManager.updateProjectType(user, project, oldProjectType);
            }
            return Either.right((Object)new SimpleErrorCollection("admin.errors.project.type.update.error", ErrorCollection.Reason.SERVER_ERROR));
        }
        return Either.left((Object)project);
    }

    private void validateProjectAssigneeType(Long assigneeType, ErrorCollection errorCollection, I18nHelper i18nHelper) {
        if (assigneeType != null && !ProjectAssigneeTypes.isValidType((Long)assigneeType)) {
            errorCollection.addErrorMessage(i18nHelper.getText("admin.errors.invalid.default.assignee"));
        }
    }

    private void validateAvatarId(Long avatarId, Project oldProject, ErrorCollection errorCollection, I18nHelper i18nHelper) {
        if (avatarId == null) {
            return;
        }
        Avatar avatar = this.avatarManager.getById(avatarId);
        if (avatar == null) {
            errorCollection.addErrorMessage(i18nHelper.getText("admin.errors.avatar.does.not.exist", (Object)avatarId), ErrorCollection.Reason.VALIDATION_FAILED);
        } else if (!avatar.isSystemAvatar() && !oldProject.getId().toString().equals(avatar.getOwner())) {
            errorCollection.addErrorMessage(i18nHelper.getText("admin.errors.invalid.avatar"));
        }
    }

    private void validateProjectUrl(String url, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (TextUtils.stringSet((String)url)) {
            if (url.length() > 255) {
                errorCollection.addError("projectUrl", i18nBean.getText("admin.errors.project.url.too.long"));
            } else if (!TextUtils.verifyUrl((String)url)) {
                errorCollection.addError("projectUrl", i18nBean.getText("admin.errors.url.specified.is.not.valid"));
            }
        }
    }

    private void validateProjectType(ApplicationUser user, ProjectTypeKey projectType, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (!this.projectTypeValidator.isValid(user, projectType)) {
            errorCollection.addError("projectType", i18nBean.getText("admin.errors.invalid.project.type"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private void validateProjectCategoryId(@Nonnull Long projectCategoryId, @Nonnull ApplicationUser user, @Nonnull ErrorCollection errorCollection, @Nonnull I18nHelper i18nBean) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            errorCollection.addError("projectCategoryId", i18nBean.getText("admin.projects.service.error.no.admin.permission.projectcategory"), ErrorCollection.Reason.FORBIDDEN);
        } else if (!this.isValidProjectCategory(projectCategoryId)) {
            errorCollection.addError("projectCategoryId", i18nBean.getText("admin.errors.project.specify.project.category"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private boolean isValidProjectCategory(Long projectCategoryId) {
        return projectCategoryId.equals(ProjectCategoryFactory.NONE_PROJECT_CATEGORY_ID) || this.projectManager.getProjectCategory(projectCategoryId) != null;
    }

    private void validateProjectKey(Project oldProject, String key, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (!this.isProjectKeyValid(key)) {
            String projectKeyWarning = this.applicationProperties.getDefaultBackedString("jira.projectkey.warning");
            if (TextUtils.stringSet((String)projectKeyWarning)) {
                errorCollection.addError("projectKey", i18nBean.getText(projectKeyWarning));
            } else {
                errorCollection.addError("projectKey", i18nBean.getText("admin.errors.must.specify.unique.project.key"));
            }
        } else if (this.isReservedKeyword(key)) {
            errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.keyword.invalid"));
        } else if (key.length() > this.getMaximumKeyLength()) {
            errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.key.too.long", (Object)this.getMaximumKeyLength()));
        } else {
            Project projectByNewKey = this.projectManager.getProjectObjByKey(key);
            if (projectByNewKey != null) {
                if (oldProject == null || !oldProject.getId().equals(projectByNewKey.getId())) {
                    errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.with.that.key.already.exists.unknown"));
                }
            } else {
                Long projectId = this.projectKeyStore.getProjectId(key);
                if (projectId != null) {
                    errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.with.that.key.already.exists.unknown"));
                }
            }
        }
    }

    private void validateProjectLead(Option<ApplicationUser> lead, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (lead.isEmpty()) {
            errorCollection.addError("projectLead", i18nBean.getText("admin.errors.must.specify.project.lead"));
        }
    }

    private void validateProjectName(String name, ErrorCollection errorCollection, I18nHelper i18nBean) {
        this.projectNameValidator.validateForCreate(name, errorCollection, i18nBean);
    }

    private void validateProjectNameForUpdate(String name, String key, ErrorCollection errorCollection, I18nHelper i18nBean) {
        this.projectNameValidator.validateForUpdate(name, key, errorCollection, i18nBean);
    }

    protected final I18nHelper getI18nBean(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }

    boolean isReservedKeyword(String key) {
        return JiraKeyUtils.isReservedKeyword((String)key);
    }

    boolean isProjectKeyValid(String key) {
        return JiraKeyUtils.validProjectKey((String)key);
    }

    boolean checkActionPermission(ApplicationUser user, Project project, ProjectAction action) {
        return action.hasPermission(this.permissionManager, user, project);
    }

    protected final ErrorCollection makeErrorCollection(ApplicationUser user, String i18nKey, ErrorCollection.Reason reason, String ... params) {
        ErrorCollection errors = ErrorCollections.empty();
        I18nHelper i18nBean = this.getI18nBean(user);
        errors.addErrorMessage(i18nBean.getText(i18nKey, (Object)params), reason);
        if (reason == ErrorCollection.Reason.FORBIDDEN && user == null) {
            errors.addErrorMessage(i18nBean.getText("common.forms.ajax.unauthorised.alert"), ErrorCollection.Reason.NOT_LOGGED_IN);
        }
        return errors;
    }

    private Long effectiveAssigneeType(Long requestedAssigneeType) {
        if (requestedAssigneeType != null) {
            return requestedAssigneeType;
        }
        if (this.applicationProperties.getOption("jira.option.allowunassigned")) {
            return 3L;
        }
        return 2L;
    }

    private String keyFor(String username) {
        return ApplicationUsers.getKeyFor(this.getUserByName(username));
    }

    private String nameFor(ApplicationUser user) {
        return user != null ? user.getUsername() : null;
    }

    private ApplicationUser getUserByName(String leadName) {
        return this.userManager.getUserByName(leadName);
    }

    private ProjectService.GetProjectResult checkProjectPermissionsForUser(ApplicationUser user, ProjectAction action, Project project, String projectKeyOrId, String projectNotFoundI18nKey) {
        if (project == null) {
            return new ProjectNotFoundResult(user, projectNotFoundI18nKey, projectKeyOrId);
        }
        if (!this.checkActionPermission(user, project, ProjectAction.VIEW_ARCHIVED_PROJECT)) {
            this.auditDeniedProjectAction(project, ProjectAction.VIEW_ARCHIVED_PROJECT);
            return new ProjectNotFoundResult(user, projectNotFoundI18nKey, projectKeyOrId);
        }
        if (!this.checkActionPermission(user, project, action)) {
            this.auditDeniedProjectAction(project, action);
            return new PermissionErrorResult(user, action);
        }
        return new ProjectService.GetProjectResult(project);
    }

    private void auditDeniedProjectAction(Project project, ProjectAction action) {
        if (DefaultProjectService.isViewOrBrowseAction(action)) {
            this.auditHandler.handleProjectAccessDenied(project.getKey());
        }
    }

    private static boolean isViewOrBrowseAction(ProjectAction action) {
        return action == ProjectAction.VIEW_PROJECT || action == ProjectAction.VIEW_ARCHIVED_PROJECT || action == ProjectAction.VIEW_ISSUES;
    }

    protected class PermissionErrorResult
    extends ProjectService.GetProjectResult {
        protected PermissionErrorResult(ApplicationUser user, ProjectAction action) {
            super(DefaultProjectService.this.makeErrorCollection(user, action.getErrorKey(), ErrorCollection.Reason.FORBIDDEN, new String[0]));
        }
    }

    protected class ProjectNotFoundResult
    extends ProjectService.GetProjectResult {
        protected ProjectNotFoundResult(ApplicationUser user, String i18nKey, String ... params) {
            super(DefaultProjectService.this.makeErrorCollection(user, i18nKey, ErrorCollection.Reason.NOT_FOUND, params));
        }
    }
}

