/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.request.context;

import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.context.RequestCacheContext;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticRequestCacheContext
implements RequestCacheContext {
    private static final Logger LOG = LoggerFactory.getLogger(DiagnosticRequestCacheContext.class);
    private final RequestCacheContext delegate;
    private final Clock clock;
    private final Instant birthTime;
    private final int longRunningThreshold;
    private long loadCounter = 0L;

    public DiagnosticRequestCacheContext(RequestCacheContext delegate, Clock clock, Instant birthTime, int longRunningThreshold) {
        this.delegate = delegate;
        this.clock = clock;
        this.birthTime = birthTime;
        this.longRunningThreshold = longRunningThreshold;
    }

    @Override
    @Nonnull
    public Map<Object, Object> getLocalMap(RequestCache<?, ?> requestCache) {
        return this.delegate.getLocalMap(requestCache);
    }

    @Override
    @Nullable
    public Map<Object, Object> getLocalMapIfExists(RequestCache<?, ?> requestCache) {
        return this.delegate.getLocalMapIfExists(requestCache);
    }

    @Override
    public void clearAll() {
        this.logIfLongRunning();
        this.delegate.clearAll();
    }

    @Override
    public void clearLocalMap(RequestCache<?, ?> requestCache) {
        this.delegate.clearLocalMap(requestCache);
    }

    @Override
    public void open() {
        this.delegate.open();
    }

    @Override
    public void close() {
        this.logIfLongRunning();
        this.delegate.close();
    }

    @Override
    public void markValueLoading() {
        this.delegate.markValueLoading();
        ++this.loadCounter;
        if (this.loadCounter >= 1000L) {
            this.loadCounter = 0L;
            this.logIfLongRunning();
        }
    }

    private void logIfLongRunning() {
        Instant now;
        long secondsElapsed;
        if (LOG.isDebugEnabled() && (secondsElapsed = this.birthTime.until(now = this.clock.instant(), ChronoUnit.SECONDS)) > (long)this.longRunningThreshold) {
            LOG.debug("Cache context {} running for {} seconds.", (Object)Thread.currentThread().getName(), (Object)secondsElapsed);
        }
    }
}

