/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.cluster.Node;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Objects;
import javax.annotation.Nullable;

public class NodeStatus {
    private final String nodeId;
    private final Node.NodeState nodeState;
    private final boolean isAlive;
    @Nullable
    private final Long lastHeartbeatTime;

    public NodeStatus(String nodeId, Node.NodeState nodeState, boolean isAlive, Long lastHeartbeatTime) {
        this.nodeId = nodeId;
        this.nodeState = nodeState;
        this.isAlive = isAlive;
        this.lastHeartbeatTime = lastHeartbeatTime;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Node.NodeState getNodeState() {
        return this.nodeState;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    @Nullable
    public Long getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    public String toString() {
        return "NodeStatus{nodeId='" + this.nodeId + '\'' + ", nodeState=" + (Object)((Object)this.nodeState) + ", isAlive=" + this.isAlive + ", lastHeartbeatTime=" + this.lastHeartbeatTimeAsLocalDateTime() + '}';
    }

    @Nullable
    private LocalDateTime lastHeartbeatTimeAsLocalDateTime() {
        return this.lastHeartbeatTime != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(this.lastHeartbeatTime), ZoneId.systemDefault()) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStatus that = (NodeStatus)o;
        return this.isAlive == that.isAlive && Objects.equals(this.nodeId, that.nodeId) && this.nodeState == that.nodeState && Objects.equals(this.lastHeartbeatTime, that.lastHeartbeatTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeId, this.nodeState, this.isAlive, this.lastHeartbeatTime});
    }
}

