/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizClusterNodeStore {
    private static final Logger log = LoggerFactory.getLogger(OfBizClusterNodeStore.class);
    public static final String ENTITY = "ClusterNode";
    public static final String NODE_ID = "nodeId";
    public static final String NODE_STATE = "nodeState";
    public static final String TIMESTAMP = "timestamp";
    static final String IP = "ip";
    static final String CACHE_LISTENER_PORT = "cacheListenerPort";
    static final String NODE_BUILD_NUMBER = "nodeBuildNumber";
    static final String NODE_VERSION = "nodeVersion";
    private final OfBizDelegator ofBizDelegator;

    public OfBizClusterNodeStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    public Node createNode(@Nonnull String nodeId, @Nonnull Node.NodeState state, @Nonnull String ip, @Nonnull Long cacheListenerPort, @Nonnull Long nodeBuildNumber, String nodeVersion) {
        Node node = new Node(nodeId, state, System.currentTimeMillis(), ip, cacheListenerPort, nodeBuildNumber, nodeVersion);
        return this.storeFieldMap(OfBizClusterNodeStore.getFields(node), true);
    }

    public Node updateNode(@Nonnull String nodeId, @Nonnull Node.NodeState state, @Nonnull String ip, @Nonnull Long cacheListenerPort, @Nonnull Long nodeBuildNumber, String nodeVersion) {
        Node node = new Node(nodeId, state, System.currentTimeMillis(), ip, cacheListenerPort, nodeBuildNumber, nodeVersion);
        return this.storeFieldMap(OfBizClusterNodeStore.getFields(node), false);
    }

    public int deleteNode(Node node) {
        return this.ofBizDelegator.removeByCondition(ENTITY, (EntityCondition)new EntityExpr(NODE_ID, EntityOperator.EQUALS, (Object)node.getNodeId()));
    }

    @Nullable
    public Node getNode(String nodeId) {
        GenericValue gv = this.ofBizDelegator.findByPrimaryKey(ENTITY, OfBizClusterNodeStore.getPkFields(nodeId));
        return gv != null ? OfBizClusterNodeStore.fromGv(gv) : null;
    }

    public List<Node> getAllNodes() {
        return this.findNodes(null, null);
    }

    public List<Node> findNodes(EntityCondition condition, List<String> orderBy) {
        ImmutableList.Builder list = ImmutableList.builder();
        List genericValues = this.ofBizDelegator.findByCondition(ENTITY, condition, null, orderBy);
        for (GenericValue genericValue : genericValues) {
            list.add((Object)OfBizClusterNodeStore.fromGv(genericValue));
        }
        return list.build();
    }

    private Node storeFieldMap(@Nonnull Map<String, Object> fields, boolean create) {
        GenericValue gv = this.ofBizDelegator.makeValue(ENTITY, fields);
        try {
            if (create) {
                gv.create();
            } else {
                gv.store();
            }
            this.logNodeUpdate(gv);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Problem storing node", (Throwable)e);
        }
        return OfBizClusterNodeStore.fromGv(gv);
    }

    private void logNodeUpdate(GenericValue gv) {
        String nodeId = gv.getString(NODE_ID);
        String nodeState = gv.getString(NODE_STATE);
        if (log.isDebugEnabled()) {
            log.debug("Node " + nodeId + " was moved to " + nodeState + " state.", (Throwable)new Exception());
            return;
        }
        log.info("Node " + nodeId + " was moved to " + nodeState + " state.");
    }

    static Node fromGv(@Nonnull GenericValue gv) {
        Long multicastPort = gv.getLong(CACHE_LISTENER_PORT);
        String ip = gv.getString(IP);
        Long timestamp = gv.getLong(TIMESTAMP);
        Long nodeBuildNumber = gv.getLong(NODE_BUILD_NUMBER);
        String nodeVersion = gv.getString(NODE_VERSION);
        return new Node(gv.getString(NODE_ID), Node.NodeState.valueOf(gv.getString(NODE_STATE)), timestamp, ip, multicastPort, nodeBuildNumber, nodeVersion);
    }

    static Map<String, Object> getFields(Node node) {
        return new FieldMap(NODE_ID, (Object)node.getNodeId()).add(NODE_STATE, (Object)node.getState().toString()).add(TIMESTAMP, (Object)node.getTimestamp()).add(IP, (Object)node.getIp()).add(CACHE_LISTENER_PORT, (Object)node.getCacheListenerPort()).add(NODE_BUILD_NUMBER, (Object)node.getNodeBuildNumber()).add(NODE_VERSION, (Object)node.getNodeVersion());
    }

    static Map<String, Object> getPkFields(String nodeId) {
        return new FieldMap(NODE_ID, (Object)nodeId);
    }
}

