/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatorExecutorServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatorExecutorServiceFactory.class);
    private static final String THREAD_NAMING_FORMAT = "ehcache-replicator-%s";
    private static final int DEFAULT_REPLICATION_THREAD_COUNT = 20;
    private static ExecutorService executorService;

    public static synchronized void init() {
        LOG.info("EhCache replication thread pool initialization");
        Integer threadCount = ReplicatorExecutorServiceFactory.getThreadCount();
        executorService = new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(THREAD_NAMING_FORMAT).build(), new RunInCallingThread());
    }

    public static synchronized void shutdown() {
        if (executorService != null) {
            LOG.info("EhCache replication thread pool shutdown");
            executorService.shutdown();
        }
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    private static Integer getThreadCount() {
        JiraProperties jiraProperties = JiraSystemProperties.getInstance();
        return jiraProperties.getInteger("com.atlassian.cache.parallelReplicationThreadCount", Integer.valueOf(20));
    }

    private static class RunInCallingThread
    implements RejectedExecutionHandler {
        private static final String WARNING_MESSAGE = "Cache replication thread pool is too small. Try increasing number of threads by setting system property {}";
        private final RateLimiter limiter = RateLimiter.create((double)0.1);

        private RunInCallingThread() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            this.logWarning();
            r.run();
        }

        private void logWarning() {
            if (LOG.isDebugEnabled()) {
                LOG.debug(WARNING_MESSAGE, (Object)"com.atlassian.cache.parallelReplicationThreadCount", (Object)new Throwable());
            } else if (this.limiter.tryAcquire()) {
                LOG.warn(WARNING_MESSAGE, (Object)"com.atlassian.cache.parallelReplicationThreadCount");
            }
        }
    }
}

