/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.disasterrecovery;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.config.util.SecondaryJiraHome;
import io.atlassian.fugue.Option;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public abstract class ReplicatorTask
implements Runnable {
    final File file;
    final JiraHome jiraHome;
    final SecondaryJiraHome secondaryJiraHome;

    ReplicatorTask(File file, JiraHome jiraHome, SecondaryJiraHome secondaryJiraHome) {
        this.file = file;
        this.jiraHome = jiraHome;
        this.secondaryJiraHome = secondaryJiraHome;
    }

    boolean createDirectoriesIfNecessary(String secondaryFilePath) {
        File file1 = new File(secondaryFilePath);
        File directory = file1.getParentFile();
        return directory.mkdirs() || directory.exists();
    }

    Option<String> getRelativePathOf(JiraHome jiraHome, File file) {
        if (file.getAbsolutePath().startsWith(jiraHome.getHomePath())) {
            return Option.some((Object)StringUtils.replaceOnce((String)file.getAbsolutePath(), (String)jiraHome.getHomePath(), (String)""));
        }
        return Option.none();
    }
}

