/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq;

import com.atlassian.jira.cluster.cache.ehcache.AbstractJiraCacheReplicator;
import com.atlassian.jira.cluster.cache.pauser.ReplicationPauserManager;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheManager;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOp;
import com.atlassian.jira.cluster.distribution.localq.LogPrefix;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.RemoteCacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalQCacheReplicator
extends AbstractJiraCacheReplicator {
    private static final Logger LOG = LoggerFactory.getLogger(LocalQCacheReplicator.class);
    private final Supplier<LocalQCacheManager> localQCacheManager;

    public LocalQCacheReplicator(boolean replicatePuts, boolean replicatePutsViaCopy, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals, Supplier<ReplicationPauserManager> replicationPauserManager, Supplier<LocalQCacheManager> localQCacheManager) {
        super(replicatePuts, replicatePutsViaCopy, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals, replicationPauserManager);
        this.localQCacheManager = localQCacheManager;
    }

    void onReplicationStart(LocalQCacheOp localQCacheOp) {
        String logMessage = LogPrefix.prefix() + "Start replicating cache to queues: {}, operation: {}, key: {}, stacktrace: {}";
        if (LOG.isTraceEnabled()) {
            LOG.trace(logMessage, new Object[]{localQCacheOp.getCacheName(), localQCacheOp.getAction(), localQCacheOp.getKey(), Throwables.getStackTraceAsString((Throwable)new Throwable())});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(logMessage, new Object[]{localQCacheOp.getCacheName(), localQCacheOp.getAction(), localQCacheOp.getKey(), "<only-in-trace>"});
        }
    }

    void onReplicationEnd(LocalQCacheOp localQCacheOp, int numberOfQueues, Duration duration) {
        String logMessage = LogPrefix.prefix() + "Done replicating cache to queues: {}, operation: {}, key: {}, numberOfQueues: {}, timeMillis: {}, stacktrace: {}";
        if (LOG.isTraceEnabled()) {
            LOG.trace(logMessage, new Object[]{localQCacheOp.getCacheName(), localQCacheOp.getAction(), localQCacheOp.getKey(), numberOfQueues, duration.toMillis(), Throwables.getStackTraceAsString((Throwable)new Throwable())});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(logMessage, new Object[]{localQCacheOp.getCacheName(), localQCacheOp.getAction(), localQCacheOp.getKey(), numberOfQueues, duration.toMillis(), "<only-in-trace>"});
        }
    }

    void onReplicationError(LocalQCacheOp localQCacheOp, Throwable t) {
        LOG.error(LogPrefix.prefix() + "Exception on replication of {}. {}. Cache: {} ", new Object[]{localQCacheOp.getAction(), t.getMessage(), localQCacheOp.getCacheName(), t});
    }

    @Override
    protected void replicatePutNotification(Ehcache cache, Element element) throws RemoteCacheException {
        LocalQCacheOp localQCacheOp = LocalQCacheOp.put(cache, element, this.replicatePutsViaCopy);
        this.replicateToQueue(localQCacheOp);
    }

    @Override
    protected void replicateRemovalNotification(Ehcache cache, Serializable key) throws RemoteCacheException {
        LocalQCacheOp localQCacheOp = LocalQCacheOp.remove(cache, key, this.replicatePutsViaCopy);
        this.replicateToQueue(localQCacheOp);
    }

    @Override
    protected void replicateRemoveAllNotification(Ehcache cache) {
        LocalQCacheOp localQCacheOp = LocalQCacheOp.removeAll(cache, this.replicatePutsViaCopy);
        this.replicateToQueue(localQCacheOp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateToQueue(LocalQCacheOp localQCacheOp) {
        this.onReplicationStart(localQCacheOp);
        int numberOfQueues = 0;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            numberOfQueues = this.localQCacheManager.get().addToAllQueues(localQCacheOp);
        }
        catch (Throwable e) {
            this.onReplicationError(localQCacheOp, e);
        }
        finally {
            this.onReplicationEnd(localQCacheOp, numberOfQueues, Duration.ofNanos(stopwatch.stop().elapsed(TimeUnit.NANOSECONDS)));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new LocalQCacheReplicator(this.replicatePuts, this.replicatePutsViaCopy, this.replicateUpdates, this.replicateUpdatesViaCopy, this.replicateRemovals, this.replicationPauserManager, this.localQCacheManager);
    }
}

