/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi.auth;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.SocketTimeoutException;
import javax.annotation.Nullable;

public class ClusterAuthenticationResult {
    private final boolean successful;
    private final String message;
    @Nullable
    private final Exception exception;

    public ClusterAuthenticationResult(boolean successful, String message, IOException exception) {
        Preconditions.checkNotNull((Object)message);
        this.successful = successful;
        this.message = message;
        this.exception = exception;
    }

    public ClusterAuthenticationResult(boolean successful, String message) {
        this(successful, message, null);
    }

    public ClusterAuthenticationResult(boolean successful) {
        this(successful, "", null);
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getMessage() {
        return this.message;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isTimeout() {
        return this.exception != null && this.exception instanceof SocketTimeoutException;
    }

    public String toString() {
        return "ClusterAuthenticationResult{successful=" + this.successful + ", message='" + this.message + '\'' + ", exception=" + this.exception + ", isTimout=" + this.isTimeout() + '}';
    }
}

