/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.tape;

import com.atlassian.jira.cluster.distribution.localq.LogPrefix;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TapeSerializationContext implements AutoCloseable
{
    CONTEXT;

    private static final Logger LOG;
    private static final ThreadLocal<Boolean> IN_CONTEXT;
    private static final ThreadLocal<Pair<Serializable, Either<IOException, byte[]>>> CACHED;

    public static TapeSerializationContext create() {
        if (IN_CONTEXT.get().booleanValue()) {
            LOG.warn(LogPrefix.prefix() + "The context is already open. Each context needs to be closed by calling the #close() method.", new Throwable());
        } else {
            IN_CONTEXT.set(Boolean.TRUE);
        }
        return CONTEXT;
    }

    @Override
    public void close() {
        CACHED.remove();
        IN_CONTEXT.remove();
    }

    static byte[] serialize(Serializable serializable) throws IOException {
        Either either;
        if (IN_CONTEXT.get().booleanValue()) {
            if (TapeSerializationContext.isCacheInvalid(serializable)) {
                CACHED.set((Pair<Serializable, Either<IOException, byte[]>>)Pair.pair((Object)serializable, TapeSerializationContext.toBytes(serializable)));
            }
            either = (Either)CACHED.get().right();
        } else {
            either = TapeSerializationContext.toBytes(serializable);
        }
        return (byte[])either.right().getOrThrow(() -> (IOException)either.left().get());
    }

    private static boolean isCacheInvalid(Serializable serializable) {
        if (CACHED.get() == null) {
            return true;
        }
        if (CACHED.get().left() != serializable) {
            LOG.warn(LogPrefix.prefix() + "The context has cached another object and the new one will be overridden. This may be because the previous context is not closed or during the current context the #serialize method is called with different objects.", new Throwable());
            return true;
        }
        return false;
    }

    private static Either<IOException, byte[]> toBytes(Serializable serializable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
            outputStream.writeObject(serializable);
            outputStream.flush();
            return Either.right((Object)byteArrayOutputStream.toByteArray());
        }
        catch (IOException e) {
            return Either.left((Object)e);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(TapeSerializationContext.class);
        IN_CONTEXT = ThreadLocal.withInitial(() -> Boolean.FALSE);
        CACHED = ThreadLocal.withInitial(() -> null);
    }
}

