/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.cluster.lock.NodeSharedHomeStatus;
import com.atlassian.jira.cluster.lock.SharedHomeNodeStatusReader;
import com.atlassian.jira.cluster.lock.SharedHomeNodeStatusWriter;
import com.atlassian.jira.config.util.FileStores;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSharedHomeNodeIO
implements SharedHomeNodeStatusReader,
SharedHomeNodeStatusWriter {
    private static final Logger log = LoggerFactory.getLogger(DefaultSharedHomeNodeIO.class);
    private final FileStores fileStores;

    public DefaultSharedHomeNodeIO(FileStores fileStores) {
        this.fileStores = fileStores;
    }

    private FileStore.Path getNodeStatusFile(@Nonnull String nodeId) {
        return this.fileStores.getHomePath().path(new String[]{"node-status", nodeId});
    }

    @Override
    @Nullable
    public NodeSharedHomeStatus readNodeStatus(@Nonnull String nodeId) {
        FileStore.Path nodeStatusFile = this.getNodeStatusFile(nodeId);
        try {
            if (!nodeStatusFile.fileExists()) {
                return null;
            }
            String content = (String)nodeStatusFile.fileReader().read(is -> new String(ByteStreams.toByteArray((InputStream)is), StandardCharsets.UTF_8));
            long contentTimestamp = Long.parseLong(content);
            return new NodeSharedHomeStatus(nodeId, contentTimestamp);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error reading node status file " + nodeStatusFile + ": " + e, e);
        }
    }

    @Override
    public void writeNodeStatus(@Nonnull NodeSharedHomeStatus status) {
        FileStore.Path nodeStatusFile = this.getNodeStatusFile(status.getNodeId());
        String content = String.valueOf(status.getUpdateTime());
        try {
            nodeStatusFile.fileWriter().write(content.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error writing node status file " + nodeStatusFile + ": " + e, e);
        }
    }

    @Override
    public void removeNodeStatus(@Nonnull String nodeId) {
        FileStore.Path nodeStatusFile = this.getNodeStatusFile(nodeId);
        try {
            if (nodeStatusFile.fileExists()) {
                nodeStatusFile.deleteFile();
            }
        }
        catch (IOException ex) {
            log.warn("Failed to remove node status file {}", (Object)nodeStatusFile, (Object)ex);
        }
    }
}

