/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.pico;

import com.atlassian.annotations.Internal;
import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.application.install.ApplicationInstallListener;
import com.atlassian.jira.cluster.ClusterServicesManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentContainer;
import com.atlassian.jira.component.pico.ComponentContainerFactory;
import com.atlassian.jira.component.pico.ComponentManagerStateImpl;
import com.atlassian.jira.component.pico.event.ComponentManagerStateChangedEvent;
import com.atlassian.jira.component.pico.registrar.BootstrapContainerRegistrar;
import com.atlassian.jira.component.pico.registrar.CacheManagerRegistrar;
import com.atlassian.jira.component.pico.registrar.ContainerExtender;
import com.atlassian.jira.component.pico.registrar.ContainerRegistrar;
import com.atlassian.jira.component.pico.registrar.FailedStartupContainerRegistrar;
import com.atlassian.jira.component.pico.registrar.SetupContainerRegistrar;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.webwork.WebworkClassLoaderSupplier;
import com.atlassian.jira.diagnostic.PluginDiagnostics;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.event.ComponentManagerStartedEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.memoryinspector.MemoryInspector;
import com.atlassian.jira.plugin.OsgiServiceTrackerCache;
import com.atlassian.jira.plugin.component.ComponentModuleDescriptor;
import com.atlassian.jira.startup.ReindexMessageListenerLauncher;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.Shutdown;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.johnson.JohnsonEventPredicates;
import com.atlassian.jira.util.system.GarbageCollector;
import com.atlassian.johnson.Johnson;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginSystemLifecycle;
import com.atlassian.plugin.SplitStartupPluginSystemLifecycle;
import com.atlassian.plugin.event.NotificationException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.codehaus.jackson.map.type.TypeBindings;
import org.codehaus.jackson.map.type.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.util.ValueStack;

@ParametersAreNonnullByDefault
@Internal
public class ComponentManager
implements Shutdown {
    private static final Logger log = LoggerFactory.getLogger(ComponentManager.class);
    private static final ComponentManager COMPONENT_MANAGER = new ComponentManager(new BootstrapContainerRegistrar(), new ComponentContainerFactory(), new ContainerRegistrar(), new FailedStartupContainerRegistrar(), new GarbageCollector(), new MemoryInspector(), new PluginSystem(), new SetupContainerRegistrar());
    private final BootstrapContainerRegistrar bootstrapContainerRegistrar;
    private final ComponentContainerFactory componentContainerFactory;
    private final ContainerRegistrar fullContainerRegistrar;
    private final FailedStartupContainerRegistrar failedStartupContainerRegistrar;
    private final GarbageCollector garbageCollector;
    private final MemoryInspector memoryInspector;
    private final PluginSystem pluginSystem;
    private final SetupContainerRegistrar setupContainerRegistrar;
    private volatile ComponentContainer container;
    private volatile ComponentManagerStateImpl state;

    @Nonnull
    public static ComponentManager getInstance() {
        return COMPONENT_MANAGER;
    }

    private ComponentManager(BootstrapContainerRegistrar bootstrapContainerRegistrar, ComponentContainerFactory componentContainerFactory, ContainerRegistrar fullContainerRegistrar, FailedStartupContainerRegistrar failedStartupContainerRegistrar, GarbageCollector garbageCollector, MemoryInspector memoryInspector, PluginSystem pluginSystem, SetupContainerRegistrar setupContainerRegistrar) {
        this.bootstrapContainerRegistrar = Objects.requireNonNull(bootstrapContainerRegistrar);
        this.componentContainerFactory = Objects.requireNonNull(componentContainerFactory);
        this.fullContainerRegistrar = Objects.requireNonNull(fullContainerRegistrar);
        this.failedStartupContainerRegistrar = Objects.requireNonNull(failedStartupContainerRegistrar);
        this.garbageCollector = Objects.requireNonNull(garbageCollector);
        this.memoryInspector = Objects.requireNonNull(memoryInspector);
        this.pluginSystem = Objects.requireNonNull(pluginSystem);
        this.setupContainerRegistrar = Objects.requireNonNull(setupContainerRegistrar);
        this.state = ComponentManagerStateImpl.NOT_STARTED;
    }

    public void createBootstrapContainer() {
        this.createComponentContainer(ComponentContainer.ContainerLevel.BOOTSTRAP);
        this.bootstrapContainerRegistrar.registerComponents(this.container);
        this.changeState(ComponentManagerStateImpl.CONTAINER_INITIALISED);
    }

    public void extendBootstrapContainerForSetup() {
        this.extendBootstrapContainer(this.setupContainerRegistrar);
    }

    public void extendBootstrapContainerForDisplayingErrors() {
        if (this.container != null && !this.container.getLevel().extendsBootstrap()) {
            this.extendBootstrapContainer(this.failedStartupContainerRegistrar);
        }
    }

    private void extendBootstrapContainer(ContainerExtender containerExtender) {
        ComponentContainer.ContainerLevel newContainerLevel = containerExtender.getNewContainerLevel();
        this.checkBootstrapContainerCanBeExtended(newContainerLevel.getName());
        containerExtender.extend(this.container);
        this.container.setLevel(newContainerLevel);
    }

    private void checkBootstrapContainerCanBeExtended(String containerName) {
        Preconditions.checkState((this.container != null ? 1 : 0) != 0, (String)"The bootstrap container has not been created, you cannot initialise a %s", (Object)containerName);
        Preconditions.checkState((this.container.getLevel() == ComponentContainer.ContainerLevel.BOOTSTRAP ? 1 : 0) != 0, (String)"You can only extend the Bootstrap Container, but we are currently at level %s", (Object)((Object)this.container.getLevel()));
    }

    public void createFullContainer() {
        this.createComponentContainer(ComponentContainer.ContainerLevel.FULL_CONTAINER);
        boolean startupOK = !Johnson.getEventContainer().hasEvent(JohnsonEventPredicates.blocksStartup());
        this.fullContainerRegistrar.registerComponents(this.container, startupOK);
        this.runInitializingComponents();
        this.changeState(ComponentManagerStateImpl.CONTAINER_INITIALISED);
    }

    private void runInitializingComponents() {
        Set seen = Sets.newIdentityHashSet();
        List<InitializingComponent> components = this.container.getComponents(InitializingComponent.class);
        for (InitializingComponent component : components) {
            try {
                if (!seen.add(component)) continue;
                component.afterInstantiation();
            }
            catch (Exception e) {
                log.error("Error occurred while initializing component '" + component.getClass().getName() + "'.", (Throwable)e);
                throw new InfrastructureException("Error occurred while initializing component '" + component.getClass().getName() + "'.", e);
            }
        }
    }

    public synchronized void earlyStartPluginSystem() {
        this.preWarmJacksonTypeCache();
        this.loadPluginSystemEventListeners();
        this.pluginSystem.earlyStartup();
        this.changeState(ComponentManagerStateImpl.PLUGIN_SYSTEM_STARTED);
        PluginAccessor pluginAccessor = this.getRequiredComponent(PluginAccessor.class);
        this.registerPlugins1Components(pluginAccessor);
        this.registerClassLoader(pluginAccessor.getClassLoader());
        this.changeState(ComponentManagerStateImpl.COMPONENTS_REGISTERED);
        this.container.instantiateComponents();
        this.changeState(ComponentManagerStateImpl.COMPONENTS_INSTANTIATED);
        this.startStartableComponents();
        this.container.registerEventComponents();
        this.changeState(ComponentManagerStateImpl.STARTED);
        this.publishEvent(ComponentManagerStartedEvent.INSTANCE);
    }

    private void preWarmJacksonTypeCache() {
        TypeFactory.defaultInstance().constructType(HashMap.class, (TypeBindings)null);
    }

    private void loadPluginSystemEventListeners() {
        this.getComponent(PluginDiagnostics.class);
        Optional.ofNullable(this.getComponent(ApplicationInstallListener.class)).ifPresent(ApplicationInstallListener::register);
    }

    private void registerPlugins1Components(PluginAccessor pluginAccessor) {
        pluginAccessor.getEnabledModuleDescriptorsByClass(ComponentModuleDescriptor.class).forEach(componentModuleDescriptor -> componentModuleDescriptor.registerComponent(this.container));
    }

    private void registerClassLoader(ClassLoader classLoader) {
        this.getRequiredComponent(WebworkClassLoaderSupplier.class).set(classLoader);
        this.container.internalInstance(classLoader);
    }

    public synchronized void lateStartPluginSystem() {
        this.pluginSystem.lateStartup();
    }

    private <T> T getRequiredComponent(Class<T> type) {
        return this.maybeGetComponent(type).orElseThrow(IllegalStateException::new);
    }

    private void publishEvent(Object event) {
        this.maybeGetComponent(EventPublisher.class).ifPresent(eventPublisher -> eventPublisher.publish(event));
    }

    private void createComponentContainer(ComponentContainer.ContainerLevel level) {
        Preconditions.checkState((this.container == null ? 1 : 0) != 0, (Object)"Component container already exists");
        this.container = this.componentContainerFactory.newContainer(level);
    }

    public boolean componentsAvailable() {
        return this.getContainerLevel().filter(level -> level.extendsBootstrap() || level == ComponentContainer.ContainerLevel.FULL_CONTAINER && this.state.isComponentsInstantiated()).isPresent();
    }

    private void startStartableComponents() {
        Set seen = Sets.newIdentityHashSet();
        List<Startable> startables = this.container.getComponents(Startable.class);
        for (Startable startable : startables) {
            try {
                if (!seen.add(startable) || startable instanceof PluginSystemLifecycle) continue;
                startable.start();
            }
            catch (Exception e) {
                log.error("Error occurred while starting component '" + startable.getClass().getName() + "'.", (Throwable)e);
                throw new InfrastructureException("Error occurred while starting component '" + startable.getClass().getName() + "'.", e);
            }
        }
    }

    public synchronized void stopPluginSystem() {
        this.publishEvent(ComponentManagerShutdownEvent.INSTANCE);
        this.pluginSystem.shutdown();
    }

    public void discardContainer() {
        PropertyUtils.clearDescriptors();
        this.changeState(ComponentManagerStateImpl.NOT_STARTED);
        if (this.container != null) {
            CacheManagerRegistrar.shutDownCacheManager(this.container, ManagementFactory.getPlatformMBeanServer());
            this.container.dispose();
            this.container = null;
        }
        this.garbageCollector.runGc();
    }

    public void shutdown() {
        this.stopPluginSystem();
        this.discardContainer();
    }

    @Nonnull
    public State getState() {
        return this.state;
    }

    public PluginSystemState getPluginSystemState() {
        return this.pluginSystem.getState();
    }

    @Nonnull
    Optional<ComponentContainer.ContainerLevel> getContainerLevel() {
        return Optional.ofNullable(this.container).map(ComponentContainer::getLevel);
    }

    private void changeState(ComponentManagerStateImpl newState) {
        Objects.requireNonNull(newState);
        ComponentManagerStateImpl currentState = this.state;
        Preconditions.checkState((boolean)currentState.isValidNewState(newState), (String)"Cannot change ComponentManager status from %s to %s", (Object)currentState, (Object)newState);
        this.state = newState;
        this.publishEvent(new ComponentManagerStateChangedEvent(newState));
    }

    @Nullable
    public <T> T getComponentInstanceOfType(Class<T> type) {
        return this.container.getComponentInstanceOfType(type);
    }

    @Nullable
    public <T> T getComponent(Class<T> componentClass) {
        return ComponentManager.getInstance().maybeGetComponent(componentClass).orElse(null);
    }

    private <T> Optional<T> maybeGetComponent(Class<T> componentClass) {
        return Optional.ofNullable(this.container).map(container -> container.getComponent(componentClass));
    }

    @Nullable
    public <T> T getOSGiComponentInstanceOfType(Class<T> clazz) {
        Assertions.notNull((String)"class", clazz);
        OsgiServiceTrackerCache osgiServiceTrackerCache = this.getComponent(OsgiServiceTrackerCache.class);
        if (osgiServiceTrackerCache != null) {
            return osgiServiceTrackerCache.getOsgiComponentOfType(clazz);
        }
        throw new IllegalStateException();
    }

    public <T> List<T> getComponents(Class<T> type) {
        return Optional.ofNullable(this.container).map(container -> container.getComponents(type)).orElseThrow(IllegalStateException::new);
    }

    public <T> List<T> getComponentsOfType(Class<T> type) {
        return Lists.newArrayList(this.getComponentsOfTypeMap(type).values());
    }

    public <T> Map<String, T> getComponentsOfTypeMap(Class<T> type) {
        return this.container.getComponentsOfTypeMap(type);
    }

    public void registerComponent(@Nullable Class<?> interfaceClass, Class<?> componentClass) {
        if (this.container != null) {
            this.container.registerComponent(interfaceClass, componentClass);
        }
    }

    public void unregisterComponent(@Nullable Class<?> interfaceClass, Class<?> componentClass) {
        if (this.container != null) {
            this.container.unregisterComponent(interfaceClass, componentClass);
        }
    }

    public <T> T createRequestScopedComponent(Class<T> componentClass) {
        return this.container.createRequestScopedComponent(componentClass);
    }

    @Nullable
    public <T> T loadComponent(Class<T> componentClass, Collection<Object> dependencies) {
        return ComponentContainer.loadComponent(componentClass, dependencies, this.container);
    }

    public synchronized void restart() {
        log.debug("Restarting");
        this.maybeGetComponent(IndexLifecycleManager.class).ifPresent(IndexLifecycleManager::shutdown);
        this.maybeGetComponent(TaskManager.class).ifPresent(tm -> tm.shutdownAndWait(0L, TimeUnit.SECONDS));
        this.maybeGetComponent(ClusterServicesManager.class).ifPresent(ClusterServicesManager::stopServices);
        this.stopPluginSystem();
        this.discardContainer();
        MultiThreadedHttpConnectionManager.shutdownAll();
        this.memoryInspector.inspectMemoryAfterJiraShutdown();
        this.createFullContainer();
        ValueStack.clearMethods();
        this.earlyStartPluginSystem();
        this.lateStartPluginSystem();
        CoreFactory.globalRefresh();
        this.maybeGetComponent(ConstantsManager.class).ifPresent(ConstantsManager::invalidateAll);
        new ReindexMessageListenerLauncher().start();
    }

    public static interface State {
        public boolean isContainerInitialised();

        public boolean isPluginSystemStarted();

        public boolean isComponentsRegistered();

        public boolean isComponentsInstantiated();

        public boolean isStarted();

        public String getMessageKey();

        public int getPercentage();
    }

    @VisibleForTesting
    static class PluginSystem {
        private volatile PluginSystemState state = PluginSystemState.NOT_STARTED;

        PluginSystem() {
        }

        public PluginSystemState getState() {
            return this.state;
        }

        void earlyStartup() {
            if (this.state != PluginSystemState.NOT_STARTED) {
                return;
            }
            try {
                ((SplitStartupPluginSystemLifecycle)ComponentAccessor.getComponent(SplitStartupPluginSystemLifecycle.class)).earlyStartup();
                this.state = PluginSystemState.EARLY_STARTED;
            }
            catch (NotificationException ex) {
                Throwable cause = ex.getCause();
                throw new InfrastructureException("Error occurred while starting Plugin Manager. " + cause.getMessage(), cause);
            }
            catch (Exception e) {
                throw new InfrastructureException("Error occurred while starting Plugin Manager. " + e.getMessage(), e);
            }
        }

        void lateStartup() {
            if (this.state != PluginSystemState.EARLY_STARTED) {
                return;
            }
            this.state = PluginSystemState.LATE_STARTED;
            ((SplitStartupPluginSystemLifecycle)ComponentAccessor.getComponent(SplitStartupPluginSystemLifecycle.class)).lateStartup();
        }

        public void shutdown() {
            if (this.state == PluginSystemState.NOT_STARTED) {
                return;
            }
            try {
                ((PluginSystemLifecycle)ComponentAccessor.getComponent(PluginSystemLifecycle.class)).shutdown();
            }
            catch (RuntimeException e) {
                log.error("Error occurred while shutting down the component manager.", (Throwable)e);
            }
            this.state = PluginSystemState.NOT_STARTED;
        }
    }

    public static enum PluginSystemState {
        NOT_STARTED,
        EARLY_STARTED,
        LATE_STARTED;

    }
}

