/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.pico.osgi;

import com.atlassian.jira.component.pico.ComponentContainer;
import com.atlassian.jira.component.pico.osgi.OsgiService;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.osgi.framework.ServiceFactory;

public class OsgiServiceRegistry {
    private final Set<Class<?>> serviceInterfaces = new HashSet();
    private final Map<Class<?>, Class<?>> serviceFactoryClasses = new HashMap();
    private final Set<Class<?>> serviceInterfacesWithBundleTrack = new HashSet();

    public void registerService(Class<?> serviceInterface) {
        this.validateInterface(serviceInterface);
        this.serviceInterfaces.add(serviceInterface);
    }

    public void registerService(Class<?> serviceInterface, boolean trackBundle) {
        if (trackBundle) {
            this.validateInterface(serviceInterface);
            this.serviceInterfacesWithBundleTrack.add(serviceInterface);
        } else {
            this.registerService(serviceInterface);
        }
    }

    public boolean isTrackBundleEnabled(Class<?> iface) {
        return this.serviceInterfacesWithBundleTrack.contains(iface);
    }

    private void validateInterface(Class<?> interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException(interfaceClass.getName() + " must be an interface to provide to plugins.");
        }
        if (this.serviceInterfaces.contains(interfaceClass) || this.serviceFactoryClasses.containsKey(interfaceClass)) {
            throw new IllegalArgumentException(interfaceClass.getName() + " has already been provided.");
        }
    }

    public <T> void registerServiceFactory(Class<? super T> serviceInterface, Class<? extends ServiceFactory<T>> osgiFactoryClass) {
        this.validateInterface(serviceInterface);
        this.serviceFactoryClasses.put(serviceInterface, osgiFactoryClass);
    }

    @Nonnull
    public Set<OsgiService> getServices(ComponentContainer componentContainer) {
        MultiMap instances = MultiMaps.create(HashSet::new);
        this.addRegisteredSingletonServices(componentContainer, instances);
        this.addRegisteredServiceFactories(componentContainer, instances);
        return instances.entrySet().stream().map(entry -> new OsgiService(entry.getKey(), (Set)entry.getValue())).collect(Collectors.toSet());
    }

    private void addRegisteredSingletonServices(ComponentContainer componentContainer, MultiMap<Object, Class<?>, Set<Class<?>>> instances) {
        HashSet aggregation = new HashSet(this.serviceInterfaces);
        aggregation.addAll(this.serviceInterfacesWithBundleTrack);
        for (Class<?> serviceInterface : aggregation) {
            Object serviceInstance = componentContainer.getComponentInstance(serviceInterface);
            if (serviceInstance == null) continue;
            instances.putSingle(serviceInstance, serviceInterface);
        }
    }

    private void addRegisteredServiceFactories(ComponentContainer componentContainer, MultiMap<Object, Class<?>, Set<Class<?>>> instances) {
        for (Map.Entry<Class<?>, Class<?>> export : this.serviceFactoryClasses.entrySet()) {
            Class<?> serviceInterface = export.getKey();
            Class<?> serviceFactoryClass = export.getValue();
            Object serviceFactory = componentContainer.loadComponent(serviceFactoryClass, Collections.emptySet());
            if (serviceFactory != null) {
                instances.putSingle(serviceFactory, serviceInterface);
                continue;
            }
            throw new IllegalStateException(serviceInterface.getName() + " cannot be provided to plugins: " + serviceFactoryClass.getName() + " cannot be instantiated.");
        }
    }
}

