/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.component;

import com.atlassian.jira.config.component.InvocationSwitcher;
import com.google.common.base.MoreObjects;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public class SwitchingInvocationHandler<T>
implements InvocationHandler {
    private final T enabled;
    private final T disabled;
    private final InvocationSwitcher invocationSwitcher;

    public SwitchingInvocationHandler(T enabled, T disabled, InvocationSwitcher invocationSwitcher) {
        this.enabled = Objects.requireNonNull(enabled);
        this.disabled = Objects.requireNonNull(disabled);
        this.invocationSwitcher = Objects.requireNonNull(invocationSwitcher);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        T delegate = this.invocationSwitcher.isEnabled() ? this.enabled : this.disabled;
        try {
            return method.invoke(delegate, args);
        }
        catch (InvocationTargetException ite) {
            throw (Throwable)MoreObjects.firstNonNull((Object)ite.getCause(), (Object)ite);
        }
    }
}

